/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;

public class TestRelationship
extends AbstractNeo4jTestCase {
    private String key1 = "key1";
    private String key2 = "key2";
    private String key3 = "key3";

    @Test
    public void testSimple() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Relationship rel2 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel1.delete();
        this.newTransaction();
        Assert.assertTrue((boolean)node1.getRelationships().iterator().hasNext());
        Assert.assertTrue((boolean)node2.getRelationships().iterator().hasNext());
        Assert.assertTrue((boolean)node1.getRelationships(new RelationshipType[]{MyRelTypes.TEST}).iterator().hasNext());
        Assert.assertTrue((boolean)node2.getRelationships(new RelationshipType[]{MyRelTypes.TEST}).iterator().hasNext());
        Assert.assertTrue((boolean)node1.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING).iterator().hasNext());
        Assert.assertTrue((boolean)node2.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.INCOMING).iterator().hasNext());
    }

    @Test
    public void testSimple2() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        for (int i = 0; i < 3; ++i) {
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
        }
        this.allGetRelationshipMethods(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods(node2, Direction.INCOMING);
        this.newTransaction();
        this.allGetRelationshipMethods(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods(node2, Direction.INCOMING);
        ((Relationship)node1.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING).iterator().next()).delete();
        ((Relationship)node1.getRelationships((RelationshipType)MyRelTypes.TEST_TRAVERSAL, Direction.OUTGOING).iterator().next()).delete();
        ((Relationship)node1.getRelationships((RelationshipType)MyRelTypes.TEST2, Direction.OUTGOING).iterator().next()).delete();
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
        this.allGetRelationshipMethods(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods(node2, Direction.INCOMING);
        this.newTransaction();
        this.allGetRelationshipMethods(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods(node2, Direction.INCOMING);
        for (Relationship rel : node1.getRelationships()) {
            rel.delete();
        }
        node1.delete();
        node2.delete();
    }

    @Test
    public void testSimple3() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        for (int i = 0; i < 1; ++i) {
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
        }
        this.allGetRelationshipMethods2(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods2(node2, Direction.INCOMING);
        this.newTransaction();
        this.allGetRelationshipMethods2(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods2(node2, Direction.INCOMING);
        ((Relationship)node1.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING).iterator().next()).delete();
        ((Relationship)node1.getRelationships((RelationshipType)MyRelTypes.TEST_TRAVERSAL, Direction.OUTGOING).iterator().next()).delete();
        ((Relationship)node1.getRelationships((RelationshipType)MyRelTypes.TEST2, Direction.OUTGOING).iterator().next()).delete();
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
        this.allGetRelationshipMethods2(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods2(node2, Direction.INCOMING);
        this.newTransaction();
        this.allGetRelationshipMethods2(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods2(node2, Direction.INCOMING);
        for (Relationship rel : node1.getRelationships()) {
            rel.delete();
        }
        node1.delete();
        node2.delete();
    }

    @Test
    public void testSimple4() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        for (int i = 0; i < 2; ++i) {
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
        }
        this.allGetRelationshipMethods3(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods3(node2, Direction.INCOMING);
        this.newTransaction();
        this.allGetRelationshipMethods3(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods3(node2, Direction.INCOMING);
        ((Relationship)node1.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING).iterator().next()).delete();
        int count = 0;
        for (Relationship rel : node1.getRelationships((RelationshipType)MyRelTypes.TEST_TRAVERSAL, Direction.OUTGOING)) {
            if (count == 1) {
                rel.delete();
            }
            ++count;
        }
        ((Relationship)node1.getRelationships((RelationshipType)MyRelTypes.TEST2, Direction.OUTGOING).iterator().next()).delete();
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
        this.allGetRelationshipMethods3(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods3(node2, Direction.INCOMING);
        this.newTransaction();
        this.allGetRelationshipMethods3(node1, Direction.OUTGOING);
        this.allGetRelationshipMethods3(node2, Direction.INCOMING);
        for (Relationship rel : node1.getRelationships()) {
            rel.delete();
        }
        node1.delete();
        node2.delete();
    }

    private void allGetRelationshipMethods(Node node, Direction dir) {
        this.countRelationships(9, node.getRelationships());
        this.countRelationships(9, node.getRelationships(dir));
        this.countRelationships(9, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(6, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2}));
        this.countRelationships(6, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(6, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(3, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        this.countRelationships(3, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2}));
        this.countRelationships(3, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(3, node.getRelationships((RelationshipType)MyRelTypes.TEST, dir));
        this.countRelationships(3, node.getRelationships((RelationshipType)MyRelTypes.TEST2, dir));
        this.countRelationships(3, node.getRelationships((RelationshipType)MyRelTypes.TEST_TRAVERSAL, dir));
    }

    private void allGetRelationshipMethods2(Node node, Direction dir) {
        this.countRelationships(3, node.getRelationships());
        this.countRelationships(3, node.getRelationships(dir));
        this.countRelationships(3, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2}));
        this.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(1, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        this.countRelationships(1, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2}));
        this.countRelationships(1, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(1, node.getRelationships((RelationshipType)MyRelTypes.TEST, dir));
        this.countRelationships(1, node.getRelationships((RelationshipType)MyRelTypes.TEST2, dir));
        this.countRelationships(1, node.getRelationships((RelationshipType)MyRelTypes.TEST_TRAVERSAL, dir));
    }

    private void allGetRelationshipMethods3(Node node, Direction dir) {
        this.countRelationships(6, node.getRelationships());
        this.countRelationships(6, node.getRelationships(dir));
        this.countRelationships(6, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(4, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2}));
        this.countRelationships(4, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(4, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        this.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2}));
        this.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
        this.countRelationships(2, node.getRelationships((RelationshipType)MyRelTypes.TEST, dir));
        this.countRelationships(2, node.getRelationships((RelationshipType)MyRelTypes.TEST2, dir));
        this.countRelationships(2, node.getRelationships((RelationshipType)MyRelTypes.TEST_TRAVERSAL, dir));
    }

    private void countRelationships(int expectedCount, Iterable<Relationship> rels) {
        int count = 0;
        for (Relationship r : rels) {
            ++count;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
    }

    @Test
    public void testRelationshipCreateAndDelete() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship relationship = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Relationship[] relArray1 = this.getRelationshipArray(node1.getRelationships());
        Relationship[] relArray2 = this.getRelationshipArray(node2.getRelationships());
        Assert.assertEquals((long)1L, (long)relArray1.length);
        Assert.assertEquals((Object)relationship, (Object)relArray1[0]);
        Assert.assertEquals((long)1L, (long)relArray2.length);
        Assert.assertEquals((Object)relationship, (Object)relArray2[0]);
        relArray1 = this.getRelationshipArray(node1.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        Assert.assertEquals((long)1L, (long)relArray1.length);
        Assert.assertEquals((Object)relationship, (Object)relArray1[0]);
        relArray2 = this.getRelationshipArray(node2.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        Assert.assertEquals((long)1L, (long)relArray2.length);
        Assert.assertEquals((Object)relationship, (Object)relArray2[0]);
        relArray1 = this.getRelationshipArray(node1.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
        Assert.assertEquals((long)1L, (long)relArray1.length);
        relArray2 = this.getRelationshipArray(node2.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.INCOMING));
        Assert.assertEquals((long)1L, (long)relArray2.length);
        relArray1 = this.getRelationshipArray(node1.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.INCOMING));
        Assert.assertEquals((long)0L, (long)relArray1.length);
        relArray2 = this.getRelationshipArray(node2.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
        Assert.assertEquals((long)0L, (long)relArray2.length);
        relationship.delete();
        node2.delete();
        node1.delete();
    }

    private Relationship[] getRelationshipArray(Iterable<Relationship> relsIterable) {
        ArrayList<Relationship> relList = new ArrayList<Relationship>();
        for (Relationship rel : relsIterable) {
            relList.add(rel);
        }
        return relList.toArray(new Relationship[relList.size()]);
    }

    @Test
    public void testDeleteWithRelationship() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship relationship = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        node1.delete();
        node2.delete();
        try {
            this.getTransaction().success();
            this.getTransaction().finish();
            Assert.fail((String)"deleting node with relaitonship should not commit.");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setTransaction(this.getGraphDb().beginTx());
    }

    @Test
    public void testDeletedRelationship() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship relationship = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        relationship.delete();
        try {
            relationship.setProperty("key1", (Object)new Integer(1));
            Assert.fail((String)"Adding property to deleted rel should throw exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
        node1.delete();
        node2.delete();
    }

    @Test
    public void testRelationshipAddProperty() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Relationship rel2 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
        try {
            rel1.setProperty(null, null);
            Assert.fail((String)"Null argument should result in exception.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string1 = new String("1");
        String string2 = new String("2");
        rel1.setProperty(this.key1, (Object)int1);
        rel2.setProperty(this.key1, (Object)string1);
        rel1.setProperty(this.key2, (Object)string2);
        rel2.setProperty(this.key2, (Object)int2);
        Assert.assertTrue((boolean)rel1.hasProperty(this.key1));
        Assert.assertTrue((boolean)rel2.hasProperty(this.key1));
        Assert.assertTrue((boolean)rel1.hasProperty(this.key2));
        Assert.assertTrue((boolean)rel2.hasProperty(this.key2));
        Assert.assertTrue((!rel1.hasProperty(this.key3) ? 1 : 0) != 0);
        Assert.assertTrue((!rel2.hasProperty(this.key3) ? 1 : 0) != 0);
        Assert.assertEquals((Object)int1, (Object)rel1.getProperty(this.key1));
        Assert.assertEquals((Object)string1, (Object)rel2.getProperty(this.key1));
        Assert.assertEquals((Object)string2, (Object)rel1.getProperty(this.key2));
        Assert.assertEquals((Object)int2, (Object)rel2.getProperty(this.key2));
        this.getTransaction().failure();
    }

    @Test
    public void testRelationshipRemoveProperty() {
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string1 = new String("1");
        String string2 = new String("2");
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Relationship rel2 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
        try {
            if (rel1.removeProperty(this.key1) != null) {
                Assert.fail((String)"Remove of non existing property should return null");
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            rel1.removeProperty(null);
            Assert.fail((String)"Remove null property should throw exception.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        rel1.setProperty(this.key1, (Object)int1);
        rel2.setProperty(this.key1, (Object)string1);
        rel1.setProperty(this.key2, (Object)string2);
        rel2.setProperty(this.key2, (Object)int2);
        try {
            rel1.removeProperty(null);
            Assert.fail((String)"Null argument should result in exception.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)int1, (Object)rel1.removeProperty(this.key1));
        Assert.assertEquals((Object)string1, (Object)rel2.removeProperty(this.key1));
        try {
            if (rel2.removeProperty(this.key1) != null) {
                Assert.fail((String)"Remove of non existing property should return null");
            }
        }
        catch (NotFoundException e) {
            this.getTransaction().failure();
        }
        rel1.delete();
        rel2.delete();
        node1.delete();
        node2.delete();
    }

    @Test
    public void testRelationshipChangeProperty() {
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string1 = new String("1");
        String string2 = new String("2");
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Relationship rel2 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
        rel1.setProperty(this.key1, (Object)int1);
        rel2.setProperty(this.key1, (Object)string1);
        rel1.setProperty(this.key2, (Object)string2);
        rel2.setProperty(this.key2, (Object)int2);
        try {
            rel1.setProperty(null, null);
            Assert.fail((String)"Null argument should result in exception.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (NotFoundException e) {
            Assert.fail((String)"wrong exception");
        }
        rel2.setProperty(this.key1, (Object)int1);
        rel1.delete();
        rel2.delete();
        node2.delete();
        node1.delete();
    }

    @Test
    public void testRelationshipChangeProperty2() {
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string1 = new String("1");
        String string2 = new String("2");
        Boolean bool1 = new Boolean(true);
        Boolean bool2 = new Boolean(false);
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel1.setProperty(this.key1, (Object)int1);
        rel1.setProperty(this.key1, (Object)int2);
        Assert.assertEquals((Object)int2, (Object)rel1.getProperty(this.key1));
        rel1.removeProperty(this.key1);
        rel1.setProperty(this.key1, (Object)string1);
        rel1.setProperty(this.key1, (Object)string2);
        Assert.assertEquals((Object)string2, (Object)rel1.getProperty(this.key1));
        rel1.removeProperty(this.key1);
        rel1.setProperty(this.key1, (Object)bool1);
        rel1.setProperty(this.key1, (Object)bool2);
        Assert.assertEquals((Object)bool2, (Object)rel1.getProperty(this.key1));
        rel1.removeProperty(this.key1);
        rel1.delete();
        node2.delete();
        node1.delete();
    }

    @Test
    public void testRelGetProperties() {
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string = new String("3");
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        try {
            rel1.getProperty(this.key1);
            Assert.fail((String)"get non existing property din't throw exception");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            rel1.getProperty(null);
            Assert.fail((String)"get of null key din't throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Assert.assertTrue((!rel1.hasProperty(this.key1) ? 1 : 0) != 0);
        Assert.assertTrue((!rel1.hasProperty(null) ? 1 : 0) != 0);
        rel1.setProperty(this.key1, (Object)int1);
        rel1.setProperty(this.key2, (Object)int2);
        rel1.setProperty(this.key3, (Object)string);
        Assert.assertTrue((boolean)rel1.hasProperty(this.key1));
        Assert.assertTrue((boolean)rel1.hasProperty(this.key2));
        Assert.assertTrue((boolean)rel1.hasProperty(this.key3));
        try {
            rel1.removeProperty(this.key3);
        }
        catch (NotFoundException e) {
            Assert.fail((String)"Remove of property failed.");
        }
        Assert.assertTrue((!rel1.hasProperty(this.key3) ? 1 : 0) != 0);
        Assert.assertTrue((!rel1.hasProperty(null) ? 1 : 0) != 0);
        rel1.delete();
        node2.delete();
        node1.delete();
    }

    @Test
    public void testDirectedRelationship() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel2 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Relationship rel3 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
        Node[] nodes = rel2.getNodes();
        Assert.assertEquals((long)2L, (long)nodes.length);
        Assert.assertTrue((nodes[0].equals(node1) && nodes[1].equals(node2) ? 1 : 0) != 0);
        nodes = rel3.getNodes();
        Assert.assertEquals((long)2L, (long)nodes.length);
        Assert.assertTrue((nodes[0].equals(node2) && nodes[1].equals(node1) ? 1 : 0) != 0);
        Assert.assertEquals((Object)node1, (Object)rel2.getStartNode());
        Assert.assertEquals((Object)node2, (Object)rel2.getEndNode());
        Assert.assertEquals((Object)node2, (Object)rel3.getStartNode());
        Assert.assertEquals((Object)node1, (Object)rel3.getEndNode());
        Relationship[] relArray = this.getRelationshipArray(node1.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
        Assert.assertEquals((long)1L, (long)relArray.length);
        Assert.assertEquals((Object)rel2, (Object)relArray[0]);
        relArray = this.getRelationshipArray(node1.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.INCOMING));
        Assert.assertEquals((long)1L, (long)relArray.length);
        Assert.assertEquals((Object)rel3, (Object)relArray[0]);
        relArray = this.getRelationshipArray(node2.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
        Assert.assertEquals((long)1L, (long)relArray.length);
        Assert.assertEquals((Object)rel3, (Object)relArray[0]);
        relArray = this.getRelationshipArray(node2.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.INCOMING));
        Assert.assertEquals((long)1L, (long)relArray.length);
        Assert.assertEquals((Object)rel2, (Object)relArray[0]);
        rel2.delete();
        rel3.delete();
        node1.delete();
        node2.delete();
    }

    @Test
    public void testRollbackDeleteRelationship() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        this.newTransaction();
        node1.delete();
        rel1.delete();
        this.getTransaction().failure();
        this.getTransaction().finish();
        this.setTransaction(this.getGraphDb().beginTx());
        node1.delete();
        node2.delete();
        rel1.delete();
    }

    @Test
    public void testCreateRelationshipWithCommitts() {
        Node n1 = this.getGraphDb().createNode();
        this.newTransaction();
        this.clearCache();
        n1 = this.getGraphDb().getNodeById((long)((int)n1.getId()));
        Node n2 = this.getGraphDb().createNode();
        n1.createRelationshipTo(n2, (RelationshipType)MyRelTypes.TEST);
        this.newTransaction();
        Relationship[] relArray = this.getRelationshipArray(n1.getRelationships());
        Assert.assertEquals((long)1L, (long)relArray.length);
        relArray = this.getRelationshipArray(n1.getRelationships());
        relArray[0].delete();
        n1.delete();
        n2.delete();
    }

    @Test
    public void testAddPropertyThenDelete() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("test", (Object)"test");
        this.newTransaction();
        rel.setProperty("test2", (Object)"test2");
        rel.delete();
        node1.delete();
        node2.delete();
        this.newTransaction();
    }

    @Test
    public void testRelationshipIsType() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Assert.assertTrue((boolean)rel.isType((RelationshipType)MyRelTypes.TEST));
        Assert.assertTrue((boolean)rel.isType(new RelationshipType(){

            public String name() {
                return MyRelTypes.TEST.name();
            }
        }));
        Assert.assertFalse((boolean)rel.isType((RelationshipType)MyRelTypes.TEST_TRAVERSAL));
        rel.delete();
        node1.delete();
        node2.delete();
    }

    @Test
    public void testChangeProperty() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("test", (Object)"test1");
        this.newTransaction();
        rel.setProperty("test", (Object)"test2");
        rel.removeProperty("test");
        rel.setProperty("test", (Object)"test3");
        Assert.assertEquals((Object)"test3", (Object)rel.getProperty("test"));
        rel.removeProperty("test");
        rel.setProperty("test", (Object)"test4");
        this.newTransaction();
        Assert.assertEquals((Object)"test4", (Object)rel.getProperty("test"));
    }

    @Test
    public void testChangeProperty2() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("test", (Object)"test1");
        this.newTransaction();
        rel.removeProperty("test");
        rel.setProperty("test", (Object)"test3");
        Assert.assertEquals((Object)"test3", (Object)rel.getProperty("test"));
        this.newTransaction();
        Assert.assertEquals((Object)"test3", (Object)rel.getProperty("test"));
        rel.removeProperty("test");
        rel.setProperty("test", (Object)"test4");
        this.newTransaction();
        Assert.assertEquals((Object)"test4", (Object)rel.getProperty("test"));
    }
}

