/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedReadOnlyGraphDatabase;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;

public class TestReadOnlyNeo4j
extends AbstractNeo4jTestCase {
    @Test
    public void testSimple() {
        EmbeddedReadOnlyGraphDatabase readGraphDb = new EmbeddedReadOnlyGraphDatabase(TestReadOnlyNeo4j.getStorePath("neo-test"));
        Transaction tx = readGraphDb.beginTx();
        int count = 0;
        for (Node node : readGraphDb.getAllNodes()) {
            for (Relationship rel : node.getRelationships()) {
                rel.getOtherNode(node);
                for (String key : rel.getPropertyKeys()) {
                    rel.getProperty(key);
                }
            }
            for (String key : node.getPropertyKeys()) {
                node.getProperty(key);
            }
            if (count++ < 10) continue;
            break;
        }
        tx.success();
        tx.finish();
        tx = readGraphDb.beginTx();
        try {
            readGraphDb.createNode();
        }
        catch (ReadOnlyDbException e) {
            // empty catch block
        }
        tx.finish();
        readGraphDb.shutdown();
    }

    @Test
    public void testReadOnlyOperationsAndNoTransaction() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"TEST"));
        node1.setProperty("key1", (Object)"value1");
        rel.setProperty("key1", (Object)"value1");
        this.commit();
        try {
            this.getGraphDb().createNode();
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"TEST2"));
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node1.setProperty("key1", (Object)"value2");
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            rel.removeProperty("key1");
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        this.getEmbeddedGraphDb().getConfig().getGraphDbModule().getNodeManager().clearCache();
        Assert.assertEquals((Object)node1, (Object)this.getGraphDb().getNodeById(node1.getId()));
        Assert.assertEquals((Object)node2, (Object)this.getGraphDb().getNodeById(node2.getId()));
        Assert.assertEquals((Object)rel, (Object)this.getGraphDb().getRelationshipById(rel.getId()));
        this.getEmbeddedGraphDb().getConfig().getGraphDbModule().getNodeManager().clearCache();
        Assert.assertEquals((Object)"value1", (Object)node1.getProperty("key1"));
        Relationship loadedRel = node1.getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"TEST"), Direction.OUTGOING);
        Assert.assertEquals((Object)rel, (Object)loadedRel);
        Assert.assertEquals((Object)"value1", (Object)loadedRel.getProperty("key1"));
    }
}

