/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

public class TestIsolation
extends AbstractNeo4jTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTransactionIsolation() {
        Relationship r1;
        Node n2;
        Node n1;
        this.commit();
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        Transaction tx = this.getGraphDb().beginTx();
        try {
            n1 = this.getGraphDb().createNode();
            n2 = this.getGraphDb().createNode();
            r1 = n1.createRelationshipTo(n2, (RelationshipType)DynamicRelationshipType.withName((String)"TEST"));
            tx.success();
        }
        finally {
            tx.finish();
        }
        final Node node1 = n1;
        final Node node2 = n2;
        final Relationship rel1 = r1;
        tx = this.getGraphDb().beginTx();
        try {
            node1.setProperty("key", (Object)"old");
            rel1.setProperty("key", (Object)"old");
            tx.success();
        }
        finally {
            tx.finish();
        }
        this.assertPropertyEqual((PropertyContainer)node1, "key", "old");
        this.assertPropertyEqual((PropertyContainer)rel1, "key", "old");
        this.assertRelationshipCount(node1, 1);
        this.assertRelationshipCount(node2, 1);
        Thread t1 = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Transaction tx = TestIsolation.this.getGraphDb().beginTx();
                try {
                    node1.setProperty("key", (Object)"new");
                    rel1.setProperty("key", (Object)"new");
                    node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"TEST"));
                    TestIsolation.this.assertPropertyEqual((PropertyContainer)node1, "key", "new");
                    TestIsolation.this.assertPropertyEqual((PropertyContainer)rel1, "key", "new");
                    TestIsolation.this.assertRelationshipCount(node1, 2);
                    TestIsolation.this.assertRelationshipCount(node2, 2);
                    latch1.countDown();
                    latch2.await();
                    TestIsolation.this.assertPropertyEqual((PropertyContainer)node1, "key", "new");
                    TestIsolation.this.assertPropertyEqual((PropertyContainer)rel1, "key", "new");
                    TestIsolation.this.assertRelationshipCount(node1, 2);
                    TestIsolation.this.assertRelationshipCount(node2, 2);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.interrupted();
                }
                finally {
                    tx.finish();
                    TestIsolation.this.assertPropertyEqual((PropertyContainer)node1, "key", "old");
                    TestIsolation.this.assertPropertyEqual((PropertyContainer)rel1, "key", "old");
                    TestIsolation.this.assertRelationshipCount(node1, 1);
                    TestIsolation.this.assertRelationshipCount(node2, 1);
                }
            }
        });
        t1.start();
        try {
            latch1.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.assertPropertyEqual((PropertyContainer)node1, "key", "old");
        this.assertPropertyEqual((PropertyContainer)rel1, "key", "old");
        this.assertRelationshipCount(node1, 1);
        this.assertRelationshipCount(node2, 1);
        latch2.countDown();
        try {
            t1.join();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.assertPropertyEqual((PropertyContainer)node1, "key", "old");
        this.assertPropertyEqual((PropertyContainer)rel1, "key", "old");
        this.assertRelationshipCount(node1, 1);
        this.assertRelationshipCount(node2, 1);
        tx = this.getGraphDb().beginTx();
        try {
            for (Relationship rel : node1.getRelationships()) {
                rel.delete();
            }
            node1.delete();
            node2.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPropertyEqual(PropertyContainer primitive, String key, String value) {
        Transaction tx = this.getGraphDb().beginTx();
        try {
            Assert.assertEquals((Object)value, (Object)primitive.getProperty(key));
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertRelationshipCount(Node node, int count) {
        Transaction tx = this.getGraphDb().beginTx();
        try {
            int actualCount = 0;
            for (Relationship rel : node.getRelationships()) {
                ++actualCount;
            }
            Assert.assertEquals((long)count, (long)actualCount);
        }
        finally {
            tx.finish();
        }
    }
}

