/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.NodeManager;

public class TestCacheTypes
extends AbstractNeo4jTestCase {
    private static final String PATH = "target/var/cache-db";

    @BeforeClass
    public static void clear() {
        TestCacheTypes.deleteFileOrDirectory(new File(PATH));
    }

    private GraphDatabaseService newDb(String cacheType) {
        return new EmbeddedGraphDatabase(PATH, MapUtil.stringMap((String[])new String[]{"cache_type", cacheType}));
    }

    @Test
    public void testDefaultCache() {
        GraphDatabaseService db = this.newDb(null);
        Assert.assertEquals((Object)NodeManager.CacheType.soft, (Object)((EmbeddedGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager().getCacheType());
        db.shutdown();
    }

    @Test
    public void testWeakRefCache() {
        GraphDatabaseService db = this.newDb("weak");
        Assert.assertEquals((Object)NodeManager.CacheType.weak, (Object)((EmbeddedGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager().getCacheType());
        db.shutdown();
    }

    @Test
    public void testSoftRefCache() {
        GraphDatabaseService db = this.newDb("soft");
        Assert.assertEquals((Object)NodeManager.CacheType.soft, (Object)((EmbeddedGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager().getCacheType());
        db.shutdown();
    }

    @Test
    public void testNoCache() {
        GraphDatabaseService db = this.newDb("none");
        Assert.assertEquals((Object)NodeManager.CacheType.none, (Object)((EmbeddedGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager().getCacheType());
        db.shutdown();
    }

    @Test
    public void testStrongCache() {
        GraphDatabaseService db = this.newDb("strong");
        Assert.assertEquals((Object)NodeManager.CacheType.strong, (Object)((EmbeddedGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager().getCacheType());
        db.shutdown();
    }

    @Test
    public void testOldCache() {
        GraphDatabaseService db = this.newDb("old");
        Assert.assertEquals((Object)NodeManager.CacheType.old, (Object)((EmbeddedGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager().getCacheType());
        db.shutdown();
    }

    @Test
    public void testInvalidCache() {
        try {
            this.newDb("whatever");
            Assert.fail((String)"Should've failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

