/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.batchinsert;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.batchinsert.BatchInserter;
import org.neo4j.kernel.impl.batchinsert.BatchInserterImpl;
import org.neo4j.kernel.impl.batchinsert.SimpleRelationship;

public class TestBatchInsert {
    private static Map<String, Object> properties = new HashMap<String, Object>();
    private static RelationshipType[] relTypeArray = new RelationshipType[]{RelTypes.REL_TYPE1, RelTypes.REL_TYPE2, RelTypes.REL_TYPE3, RelTypes.REL_TYPE4, RelTypes.REL_TYPE5};

    private BatchInserter newBatchInserter() {
        String storePath = AbstractNeo4jTestCase.getStorePath("neo-batch");
        AbstractNeo4jTestCase.deleteFileOrDirectory(new File(storePath));
        return new BatchInserterImpl(storePath);
    }

    @Test
    public void testSimple() {
        BatchInserter graphDb = this.newBatchInserter();
        long node1 = graphDb.createNode(null);
        long node2 = graphDb.createNode(null);
        long rel1 = graphDb.createRelationship(node1, node2, (RelationshipType)RelTypes.BATCH_TEST, null);
        SimpleRelationship rel = graphDb.getRelationshipById(rel1);
        Assert.assertEquals((long)rel.getStartNode(), (long)node1);
        Assert.assertEquals((long)rel.getEndNode(), (long)node2);
        Assert.assertEquals((Object)RelTypes.BATCH_TEST.name(), (Object)rel.getType().name());
        graphDb.shutdown();
    }

    @Test
    public void testMore() {
        BatchInserter graphDb = this.newBatchInserter();
        long startNode = graphDb.createNode(properties);
        long[] endNodes = new long[25];
        HashSet<Long> rels = new HashSet<Long>();
        for (int i = 0; i < 25; ++i) {
            endNodes[i] = graphDb.createNode(properties);
            rels.add(graphDb.createRelationship(startNode, endNodes[i], relTypeArray[i % 5], properties));
        }
        for (SimpleRelationship rel : graphDb.getRelationships(startNode)) {
            Assert.assertTrue((boolean)rels.contains(rel.getId()));
            Assert.assertEquals((long)rel.getStartNode(), (long)startNode);
        }
        graphDb.setNodeProperties(startNode, properties);
        graphDb.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadStuff() {
        BatchInserter graphDb = this.newBatchInserter();
        long startNode = graphDb.createNode(properties);
        try {
            graphDb.createRelationship(startNode, startNode, relTypeArray[0], properties);
            Assert.fail((String)"Could create relationship with same start and end node");
        }
        catch (IllegalArgumentException e) {
        }
        finally {
            graphDb.shutdown();
        }
    }

    private void setProperties(Node node) {
        for (String key : properties.keySet()) {
            node.setProperty(key, properties.get(key));
        }
    }

    private void setProperties(Relationship rel) {
        for (String key : properties.keySet()) {
            rel.setProperty(key, properties.get(key));
        }
    }

    @Test
    public void testWithGraphDbService() {
        BatchInserter batchInserter = this.newBatchInserter();
        GraphDatabaseService graphDb = batchInserter.getGraphDbService();
        Node startNode = graphDb.createNode();
        this.setProperties(startNode);
        Node[] endNodes = new Node[25];
        HashSet<Relationship> rels = new HashSet<Relationship>();
        for (int i = 0; i < 25; ++i) {
            endNodes[i] = graphDb.createNode();
            this.setProperties(endNodes[i]);
            Relationship rel = startNode.createRelationshipTo(endNodes[i], relTypeArray[i % 5]);
            rels.add(rel);
            this.setProperties(rel);
        }
        for (Relationship rel : startNode.getRelationships()) {
            Assert.assertTrue((boolean)rels.contains(rel));
            Assert.assertEquals((Object)rel.getStartNode(), (Object)startNode);
        }
        this.setProperties(startNode);
        graphDb.shutdown();
    }

    @Test
    public void testGraphDbServiceGetRelationships() {
        Iterator relItr;
        int i;
        BatchInserter batchInserter = this.newBatchInserter();
        GraphDatabaseService graphDb = batchInserter.getGraphDbService();
        Node startNode = graphDb.createNode();
        for (int i2 = 0; i2 < 5; ++i2) {
            Node endNode = graphDb.createNode();
            startNode.createRelationshipTo(endNode, relTypeArray[i2]);
        }
        try {
            startNode.createRelationshipTo(startNode, relTypeArray[0]);
            Assert.fail((String)"Could create relationship with same start and end node");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((startNode.getSingleRelationship(relTypeArray[i], Direction.OUTGOING) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 5; ++i) {
            relItr = startNode.getRelationships(relTypeArray[i], Direction.OUTGOING).iterator();
            relItr.next();
            Assert.assertTrue((!relItr.hasNext() ? 1 : 0) != 0);
        }
        for (i = 0; i < 5; ++i) {
            relItr = startNode.getRelationships(new RelationshipType[]{relTypeArray[i]}).iterator();
            relItr.next();
            Assert.assertTrue((!relItr.hasNext() ? 1 : 0) != 0);
        }
        graphDb.shutdown();
    }

    static {
        properties.put("key0", "SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA");
        properties.put("key1", 1);
        properties.put("key2", (short)2);
        properties.put("key3", 3L);
        properties.put("key4", Float.valueOf(4.0f));
        properties.put("key5", 5.0);
        properties.put("key6", (byte)6);
        properties.put("key7", true);
        properties.put("key8", Character.valueOf('\b'));
        properties.put("key10", new String[]{"SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA", "dsasda", "dssadsad"});
        properties.put("key11", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key12", new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key13", new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        properties.put("key14", new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f});
        properties.put("key15", new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        properties.put("key16", new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key17", new boolean[]{true, false, true, false});
        properties.put("key18", new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t'});
    }

    private static enum RelTypes implements RelationshipType
    {
        BATCH_TEST,
        REL_TYPE1,
        REL_TYPE2,
        REL_TYPE3,
        REL_TYPE4,
        REL_TYPE5;

    }
}

