/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl;

import java.io.File;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.core.NodeManager;

public abstract class AbstractNeo4jTestCase {
    protected static final String NEO4J_BASE_PATH = "target/var/";
    private static GraphDatabaseService graphDb;
    private Transaction tx;

    public GraphDatabaseService getGraphDb() {
        return graphDb;
    }

    public EmbeddedGraphDatabase getEmbeddedGraphDb() {
        return (EmbeddedGraphDatabase)graphDb;
    }

    protected boolean restartGraphDbBetweenTests() {
        return false;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public static String getStorePath(String endPath) {
        return NEO4J_BASE_PATH + endPath;
    }

    @BeforeClass
    public static void setUpDb() {
        AbstractNeo4jTestCase.deleteFileOrDirectory(new File(AbstractNeo4jTestCase.getStorePath("neo-test")));
        graphDb = new EmbeddedGraphDatabase(AbstractNeo4jTestCase.getStorePath("neo-test"));
    }

    @Before
    public void setUpTest() {
        if (this.restartGraphDbBetweenTests() && graphDb == null) {
            AbstractNeo4jTestCase.setUpDb();
        }
        this.tx = graphDb.beginTx();
    }

    @After
    public void tearDownTest() {
        if (this.tx != null) {
            this.tx.finish();
        }
        if (this.restartGraphDbBetweenTests()) {
            graphDb.shutdown();
            graphDb = null;
        }
    }

    @AfterClass
    public static void tearDownDb() {
        if (graphDb != null) {
            graphDb.shutdown();
        }
    }

    public void setTransaction(Transaction tx) {
        this.tx = tx;
    }

    public void newTransaction() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.finish();
        }
        this.tx = graphDb.beginTx();
    }

    public void commit() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.finish();
            this.tx = null;
        }
    }

    public void rollback() {
        if (this.tx != null) {
            this.tx.failure();
            this.tx.finish();
            this.tx = null;
        }
    }

    public NodeManager getNodeManager() {
        return ((EmbeddedGraphDatabase)graphDb).getConfig().getGraphDbModule().getNodeManager();
    }

    public static void deleteFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                AbstractNeo4jTestCase.deleteFileOrDirectory(child);
            }
        } else {
            file.delete();
        }
    }

    protected void clearCache() {
        this.getEmbeddedGraphDb().getConfig().getGraphDbModule().getNodeManager().clearCache();
    }
}

