/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ImpermanentGraphDatabase;

public class ImpermanentGraphDatabaseTests {
    private GraphDatabaseService db;

    @Before
    public void Given() {
        this.db = new ImpermanentGraphDatabase("target/var/ineodb");
    }

    @After
    public void tearDown() {
        this.db.shutdown();
    }

    @Test
    public void should_keep_data_between_start_and_shutdown() {
        this.createNode();
        Assert.assertEquals((String)"Expected one new node, plus reference node", (int)2, (int)this.nodeCount());
    }

    @Test
    public void data_should_not_survive_shutdown() {
        this.createNode();
        this.db.shutdown();
        this.db = new ImpermanentGraphDatabase("neodb");
        Assert.assertEquals((String)"Should not see anything but the default reference node.", (int)1, (int)this.nodeCount());
    }

    private int nodeCount() {
        return IteratorUtil.count((Iterable)this.db.getAllNodes());
    }

    private void createNode() {
        Transaction tx = this.db.beginTx();
        this.db.createNode();
        tx.success();
        tx.finish();
    }
}

