/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class ImpermanentGraphDatabase
extends AbstractGraphDatabase {
    private EmbeddedGraphDatabase inner;
    private String storeDir;

    public ImpermanentGraphDatabase(String storeDir, Map<String, String> params) {
        this.storeDir = storeDir;
        ImpermanentGraphDatabase.deleteRecursively(new File(storeDir));
        this.inner = new EmbeddedGraphDatabase(storeDir, params);
    }

    public ImpermanentGraphDatabase(Map<String, String> params) throws IOException {
        this(ImpermanentGraphDatabase.createTempDir(), params);
    }

    public ImpermanentGraphDatabase() throws IOException {
        this(ImpermanentGraphDatabase.createTempDir(), new HashMap<String, String>());
    }

    public ImpermanentGraphDatabase(String storeDir) {
        this(storeDir, new HashMap<String, String>());
    }

    private static String createTempDir() throws IOException {
        File d = File.createTempFile("neo4j-test", "dir");
        if (!d.delete()) {
            throw new RuntimeException("temp config directory pre-delete failed");
        }
        if (!d.mkdirs()) {
            throw new RuntimeException("temp config directory not created");
        }
        d.deleteOnExit();
        return d.getAbsolutePath();
    }

    private static void deleteRecursively(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                ImpermanentGraphDatabase.deleteRecursively(child);
            }
        }
        if (!file.delete()) {
            throw new RuntimeException("Couldn't empty database. Offending file:" + file);
        }
    }

    public Node createNode() {
        return this.inner.createNode();
    }

    public Node getNodeById(long id) {
        return this.inner.getNodeById(id);
    }

    public Relationship getRelationshipById(long id) {
        return this.inner.getRelationshipById(id);
    }

    public Node getReferenceNode() {
        return this.inner.getReferenceNode();
    }

    public Iterable<Node> getAllNodes() {
        return this.inner.getAllNodes();
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.inner.getRelationshipTypes();
    }

    public void shutdown() {
        this.inner.shutdown();
        ImpermanentGraphDatabase.deleteRecursively(new File(this.storeDir));
    }

    public boolean enableRemoteShell() {
        return this.inner.enableRemoteShell();
    }

    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        return this.inner.enableRemoteShell(initialProperties);
    }

    public Transaction beginTx() {
        return this.inner.beginTx();
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.inner.registerTransactionEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.inner.unregisterTransactionEventHandler(handler);
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.inner.registerKernelEventHandler(handler);
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.inner.unregisterKernelEventHandler(handler);
    }

    public IndexManager index() {
        return this.inner.index();
    }

    public String getStoreDir() {
        return this.inner.getStoreDir();
    }

    public Config getConfig() {
        return this.inner.getConfig();
    }

    public <T> T getManagementBean(Class<T> type) {
        return (T)this.inner.getManagementBean(type);
    }

    public boolean isReadOnly() {
        return this.inner.isReadOnly();
    }
}

