/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Args;

public class TestArgs {
    @Test
    public void testInterleavedParametersWithValuesAndNot() {
        String[] line = new String[]{"-host", "machine.foo.com", "-port", "1234", "-v", "-name", "othershell"};
        Args args = new Args(line);
        Assert.assertEquals((Object)"machine.foo.com", (Object)args.get("host", null));
        Assert.assertEquals((Object)"1234", (Object)args.get("port", null));
        Assert.assertEquals((long)1234L, (long)args.getNumber("port", null).intValue());
        Assert.assertEquals((Object)"othershell", (Object)args.get("name", null));
        Assert.assertTrue((boolean)args.has("v"));
        Assert.assertTrue((boolean)args.orphans().isEmpty());
    }

    @Test
    public void testInterleavedEqualsArgsAndSplitKeyValue() {
        String[] line = new String[]{"-host=localhost", "-v", "--port", "1234", "param1", "-name=Something", "param2"};
        Args args = new Args(line);
        Assert.assertEquals((Object)"localhost", (Object)args.get("host", null));
        Assert.assertTrue((boolean)args.has("v"));
        Assert.assertEquals((long)1234L, (long)args.getNumber("port", null).intValue());
        Assert.assertEquals((Object)"Something", (Object)args.get("name", null));
        Assert.assertEquals((long)2L, (long)args.orphans().size());
        Assert.assertEquals((Object)"param1", args.orphans().get(0));
        Assert.assertEquals((Object)"param2", args.orphans().get(1));
    }
}

