/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;

public class DynamicStringStore
extends AbstractDynamicStore {
    private static final String VERSION = "StringPropertyStore v0.9.5";

    public DynamicStringStore(String fileName, Map<?, ?> config, IdType idType) {
        super(fileName, config, idType);
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    public static void createStore(String fileName, int blockSize, IdGeneratorFactory idGeneratorFactory, IdType idType) {
        DynamicStringStore.createEmptyStore(fileName, blockSize, VERSION, idGeneratorFactory, idType);
    }

    @Override
    public void setHighId(long highId) {
        super.setHighId(highId);
    }

    @Override
    public int nextBlockId() {
        return super.nextBlockId();
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("StringPropertyStore")) {
            return false;
        }
        if (version.equals("StringPropertyStore v0.9.3")) {
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }
}

