/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class KernelExtension
extends Service {
    private static final String INSTANCE_ID = "instanceId";
    private final String key;

    protected KernelExtension(String key) {
        super(key, new String[0]);
        this.key = key;
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    public final boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass());
    }

    String getKey() {
        return this.key;
    }

    public final void agentLoad(String agentArgs) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String arg : agentArgs.split(";")) {
            String[] parts = arg.split("=", 2);
            if (parts.length == 2) {
                arg = parts[0].trim();
                if (INSTANCE_ID.equalsIgnoreCase(arg)) {
                    arg = INSTANCE_ID;
                }
                parameters.put(arg, parts[1]);
                continue;
            }
            parameters.put(arg.trim(), null);
        }
        KernelData kernel = KernelData.getInstance(parameters);
        if (kernel == null) {
            throw new IllegalStateException("could not load kernel");
        }
        kernel.extraParameters.putAll(parameters);
        this.load(kernel);
    }

    protected abstract void load(KernelData var1);

    protected void preInit(KernelData kernelData) {
    }

    protected void init(KernelData kernel) {
    }

    protected void unload(KernelData kernel) {
    }

    protected boolean isLoaded(KernelData kernel) {
        return kernel.getState(this) != null;
    }

    protected <T> Function<T> function(KernelData kernel, String name, Class<T> result, Class<?> ... params) {
        Method method;
        Class[] parameters = new Class[params == null ? 1 : params.length + 1];
        parameters[0] = KernelData.class;
        if (params != null && params.length != 0) {
            System.arraycopy(params, 0, parameters, 1, params.length);
        }
        try {
            method = this.getClass().getMethod(name, parameters);
            if (!Modifier.isPublic(method.getModifiers())) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return new Function(result, kernel, method);
    }

    public class Function<T> {
        private final Class<T> type;
        private final KernelData kernel;
        private final Method method;

        private Function(Class<T> type, KernelData kernel, Method method) {
            this.type = type;
            this.kernel = kernel;
            this.method = method;
        }

        public T call(Object ... args) {
            Object[] arguments = new Object[args == null ? 1 : args.length + 1];
            arguments[0] = this.kernel;
            if (args != null && args.length > 0) {
                System.arraycopy(args, 0, arguments, 1, args.length);
            }
            try {
                return this.type.cast(this.method.invoke((Object)KernelExtension.this, arguments));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Access denied", e);
            }
            catch (InvocationTargetException e) {
                Throwable exception = e.getTargetException();
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                throw new RuntimeException("Unexpected exception: " + exception.getClass(), exception);
            }
        }
    }

    public static abstract class KernelData {
        private static final Map<String, KernelData> instances = new HashMap<String, KernelData>();
        private static int ID_COUNTER = 0;
        private final Map<String, String> extraParameters = new HashMap<String, String>();
        private final String instanceId;
        private final Collection<KernelExtension> loadedExtensions = new ArrayList<KernelExtension>();
        private final Map<KernelExtension, Object> state = new HashMap<KernelExtension, Object>();

        private static synchronized String newInstance(KernelData instance) {
            String instanceId = Integer.toString(ID_COUNTER++);
            instances.put(instanceId, instance);
            return instanceId;
        }

        private static synchronized KernelData getInstance(Map<String, String> parameters) {
            String instanceId = parameters.remove(KernelExtension.INSTANCE_ID);
            if (instanceId != null) {
                return instances.get(instanceId);
            }
            if (instances.size() == 1) {
                return instances.values().iterator().next();
            }
            return null;
        }

        private static synchronized void removeInstance(String instanceId) {
            instances.remove(instanceId);
        }

        KernelData() {
            this.instanceId = KernelData.newInstance(this);
        }

        public final String instanceId() {
            return this.instanceId;
        }

        public final int hashCode() {
            return this.instanceId.hashCode();
        }

        public final boolean equals(Object obj) {
            return obj instanceof KernelData && this.instanceId.equals(((KernelData)obj).instanceId);
        }

        public abstract String version();

        public abstract Config getConfig();

        public abstract GraphDatabaseService graphDatabase();

        public abstract Map<Object, Object> getConfigParams();

        void preInitAll(StringLogger msgLog) {
            for (KernelExtension extension : Service.load(KernelExtension.class)) {
                try {
                    extension.preInit(this);
                    this.loadedExtensions.add(extension);
                }
                catch (Throwable t) {
                    msgLog.logMessage("Failed to init extension " + extension, t, true);
                }
            }
        }

        void initAll(StringLogger msgLog) {
            for (KernelExtension extension : this.loadedExtensions) {
                try {
                    extension.init(this);
                    this.initialized(extension);
                    msgLog.logMessage("Extension " + extension + " initialized ok", true);
                }
                catch (Throwable t) {
                    msgLog.logMessage("Failed to init extension " + extension, t, true);
                }
            }
        }

        void loadAll(StringLogger msgLog) {
            for (KernelExtension extension : this.loadedExtensions) {
                try {
                    extension.load(this);
                    msgLog.logMessage("Extension " + extension + " loaded ok", true);
                }
                catch (Throwable t) {
                    msgLog.logMessage("Failed to load extension " + extension, t, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void shutdown(StringLogger msgLog) {
            try {
                for (KernelExtension loaded : this.loadedExtensions) {
                    try {
                        loaded.unload(this);
                    }
                    catch (Throwable t) {
                        msgLog.logMessage("Error unloading " + loaded, t, true);
                    }
                }
            }
            finally {
                KernelData.removeInstance(this.instanceId);
            }
        }

        public final Object getState(KernelExtension extension) {
            return this.state.get(extension);
        }

        public final Object setState(KernelExtension extension, Object value) {
            if (value == null) {
                return this.state.remove(extension);
            }
            return this.state.put(extension, value);
        }

        public final Object getParam(String key) {
            if (this.extraParameters.containsKey(key)) {
                return this.extraParameters.get(key);
            }
            return this.getConfigParams().get(key);
        }

        protected abstract void initialized(KernelExtension var1);
    }
}

