/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.impl.cache.AdaptiveCacheManager;
import org.neo4j.kernel.impl.core.GraphDbModule;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.persistence.IdGenerator;
import org.neo4j.kernel.impl.persistence.IdGeneratorModule;
import org.neo4j.kernel.impl.persistence.PersistenceModule;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;

public class Config {
    static final String NIO_NEO_DB_CLASS = "org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource";
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    static final String LUCENE_DS_CLASS = "org.neo4j.index.lucene.LuceneDataSource";
    static final String LUCENE_FULLTEXT_DS_CLASS = "org.neo4j.index.lucene.LuceneFulltextDataSource";
    public static final String USE_MEMORY_MAPPED_BUFFERS = "use_memory_mapped_buffers";
    public static final String DUMP_CONFIGURATION = "dump_configuration";
    public static final String KEEP_LOGICAL_LOGS = "keep_logical_logs";
    public static final String ENABLE_REMOTE_SHELL = "enable_remote_shell";
    public static final String ENABLE_ONLINE_BACKUP = "enable_online_backup";
    public static final String BACKUP_SLAVE = "backup_slave";
    public static final String READ_ONLY = "read_only";
    public static final String STORAGE_DIRECTORY = "store_dir";
    public static final String REBUILD_IDGENERATORS_FAST = "rebuild_idgenerators_fast";
    public static final String NODE_STORE_MMAP_SIZE = "neostore.nodestore.db.mapped_memory";
    public static final String ARRAY_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.arrays.mapped_memory";
    public static final String PROPERTY_INDEX_KEY_STORE_MMAP_SIZE = "neostore.propertystore.db.index.keys.mapped_memory";
    public static final String PROPERTY_INDEX_STORE_MMAP_SIZE = "neostore.propertystore.db.index.mapped_memory";
    public static final String PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.mapped_memory";
    public static final String STRING_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.strings.mapped_memory";
    public static final String RELATIONSHIP_STORE_MMAP_SIZE = "neostore.relationshipstore.db.mapped_memory";
    public static final String LOGICAL_LOG = "logical_log";
    public static final String NEO_STORE = "neo_store";
    public static final String CACHE_TYPE = "cache_type";
    public static final String TXMANAGER_IMPLEMENTATION = "tx_manager_impl";
    private final AdaptiveCacheManager cacheManager;
    private final TxModule txModule;
    private final LockManager lockManager;
    private final LockReleaser lockReleaser;
    private final PersistenceModule persistenceModule;
    private boolean create = false;
    private String persistenceSourceName;
    private final IdGeneratorModule idGeneratorModule;
    private final GraphDbModule graphDbModule;
    private final String storeDir;
    private final IndexStore indexStore;
    private final Map<Object, Object> params;
    private final Map inputParams;
    private final TxEventSyncHookFactory syncHookFactory;
    private final RelationshipTypeCreator relTypeCreator;
    private final boolean readOnly;
    private final boolean backupSlave;
    private final IdGeneratorFactory idGeneratorFactory;
    private final TxIdGenerator txIdGenerator;

    Config(GraphDatabaseService graphDb, String storeDir, StoreId storeId, Map<String, String> inputParams, KernelPanicEventGenerator kpe, TxModule txModule, LockManager lockManager, LockReleaser lockReleaser, IdGeneratorFactory idGeneratorFactory, TxEventSyncHookFactory txSyncHookFactory, RelationshipTypeCreator relTypeCreator, TxIdGenerator txIdGenerator, LastCommittedTxIdSetter lastCommittedTxIdSetter) {
        this.storeDir = storeDir;
        this.inputParams = inputParams;
        this.idGeneratorFactory = idGeneratorFactory;
        this.relTypeCreator = relTypeCreator;
        this.txIdGenerator = txIdGenerator;
        this.params = Config.getDefaultParams();
        this.txModule = txModule;
        this.lockManager = lockManager;
        this.lockReleaser = lockReleaser;
        this.idGeneratorModule = new IdGeneratorModule(new IdGenerator());
        this.readOnly = Boolean.parseBoolean((String)this.params.get(READ_ONLY));
        this.backupSlave = Boolean.parseBoolean((String)this.params.get(BACKUP_SLAVE));
        this.syncHookFactory = txSyncHookFactory;
        this.persistenceModule = new PersistenceModule();
        this.cacheManager = new AdaptiveCacheManager();
        this.graphDbModule = new GraphDbModule(graphDb, this.cacheManager, lockManager, txModule.getTxManager(), this.idGeneratorModule.getIdGenerator(), this.readOnly);
        this.indexStore = new IndexStore(storeDir);
        this.params.put(IndexStore.class, this.indexStore);
        if (storeId != null) {
            this.params.put(StoreId.class, storeId);
        }
        this.params.put(IdGeneratorFactory.class, idGeneratorFactory);
        this.params.put(TxIdGenerator.class, txIdGenerator);
        this.params.put(TransactionManager.class, txModule.getTxManager());
        this.params.put(LastCommittedTxIdSetter.class, lastCommittedTxIdSetter);
        this.params.put(GraphDbModule.class, this.graphDbModule);
    }

    private static Map<Object, Object> getDefaultParams() {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put(NODE_STORE_MMAP_SIZE, "20M");
        params.put(PROPERTY_STORE_MMAP_SIZE, "90M");
        params.put(PROPERTY_INDEX_STORE_MMAP_SIZE, "1M");
        params.put(PROPERTY_INDEX_KEY_STORE_MMAP_SIZE, "1M");
        params.put(STRING_PROPERTY_STORE_MMAP_SIZE, "130M");
        params.put(ARRAY_PROPERTY_STORE_MMAP_SIZE, "130M");
        params.put(RELATIONSHIP_STORE_MMAP_SIZE, "100M");
        String nameOs = System.getProperty("os.name");
        if (nameOs.startsWith("Windows")) {
            params.put(USE_MEMORY_MAPPED_BUFFERS, "false");
        }
        return params;
    }

    void setPersistenceSource(String name, boolean create) {
        this.persistenceSourceName = name;
        this.create = create;
    }

    String getPersistenceSource() {
        return this.persistenceSourceName;
    }

    boolean getCreatePersistenceSource() {
        return this.create;
    }

    public TxModule getTxModule() {
        return this.txModule;
    }

    public GraphDbModule getGraphDbModule() {
        return this.graphDbModule;
    }

    public PersistenceModule getPersistenceModule() {
        return this.persistenceModule;
    }

    public IdGeneratorModule getIdGeneratorModule() {
        return this.idGeneratorModule;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public IndexStore getIndexStore() {
        return this.indexStore;
    }

    public LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }

    public Map<Object, Object> getParams() {
        return this.params;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    boolean isBackupSlave() {
        return this.backupSlave;
    }

    Map<Object, Object> getInputParams() {
        return this.inputParams;
    }

    TxEventSyncHookFactory getSyncHookFactory() {
        return this.syncHookFactory;
    }

    public RelationshipTypeCreator getRelationshipTypeCreator() {
        return this.relTypeCreator;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.graphDbModule.getNodeManager().getRelationshipTypeHolder();
    }

    public static void dumpConfiguration(Map<?, ?> config) {
        for (Object key : config.keySet()) {
            Object value;
            if (!(key instanceof String) || !((value = config.get(key)) instanceof String)) continue;
            System.out.println(key + "=" + value);
        }
    }

    public static Object getFromConfig(Map<?, ?> config, Object key, Object defaultValue) {
        Object result = config != null ? config.get(key) : defaultValue;
        return result != null ? result : defaultValue;
    }
}

