/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap<K, V> {
    private ArrayEntry<K, V>[] arrayEntries;
    private volatile int arrayCount = 0;
    private int toMapThreshold = 5;
    private Map<K, V> propertyMap = null;
    private final boolean useThreadSafeMap;
    private boolean switchBackToArray = false;

    public ArrayMap() {
        this.useThreadSafeMap = false;
        this.arrayEntries = new ArrayEntry[this.toMapThreshold];
    }

    public ArrayMap(int mapThreshold, boolean threadSafe, boolean shrinkToArray) {
        this.toMapThreshold = mapThreshold;
        this.useThreadSafeMap = threadSafe;
        this.switchBackToArray = shrinkToArray;
        this.arrayEntries = new ArrayEntry[this.toMapThreshold];
    }

    public void put(K key, V value) {
        int i;
        if (this.useThreadSafeMap) {
            this.synchronizedPut(key, value);
            return;
        }
        for (i = 0; i < this.arrayCount; ++i) {
            if (!this.arrayEntries[i].getKey().equals(key)) continue;
            this.arrayEntries[i].setNewValue(value);
            return;
        }
        if (this.arrayCount != -1) {
            if (this.arrayCount < this.arrayEntries.length) {
                this.arrayEntries[this.arrayCount++] = new ArrayEntry<K, V>(key, value);
            } else {
                this.propertyMap = new HashMap(this.arrayEntries.length * 2);
                for (i = 0; i < this.arrayCount; ++i) {
                    this.propertyMap.put(this.arrayEntries[i].getKey(), this.arrayEntries[i].getValue());
                }
                this.arrayEntries = null;
                this.arrayCount = -1;
                this.propertyMap.put(key, value);
            }
        } else {
            this.propertyMap.put(key, value);
        }
    }

    private synchronized void synchronizedPut(K key, V value) {
        int i;
        for (i = 0; i < this.arrayCount; ++i) {
            if (!this.arrayEntries[i].getKey().equals(key)) continue;
            this.arrayEntries[i].setNewValue(value);
            return;
        }
        if (this.arrayCount != -1) {
            if (this.arrayCount < this.arrayEntries.length) {
                this.arrayEntries[this.arrayCount++] = new ArrayEntry<K, V>(key, value);
            } else {
                this.propertyMap = new HashMap(this.arrayEntries.length * 2);
                for (i = 0; i < this.arrayCount; ++i) {
                    this.propertyMap.put(this.arrayEntries[i].getKey(), this.arrayEntries[i].getValue());
                }
                this.arrayEntries = null;
                this.arrayCount = -1;
                this.propertyMap.put(key, value);
            }
        } else {
            this.propertyMap.put(key, value);
        }
    }

    public V get(K key) {
        if (key == null) {
            return null;
        }
        if (this.useThreadSafeMap) {
            return this.synchronizedGet(key);
        }
        int count = this.arrayCount;
        for (int i = 0; i < count; ++i) {
            ArrayEntry<K, V> entry = this.arrayEntries[i];
            if (entry == null || !key.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        if (this.arrayCount == -1) {
            return this.propertyMap.get(key);
        }
        return null;
    }

    private synchronized V synchronizedGet(K key) {
        for (int i = 0; i < this.arrayCount; ++i) {
            if (!key.equals(this.arrayEntries[i].getKey())) continue;
            return this.arrayEntries[i].getValue();
        }
        if (this.arrayCount == -1) {
            return this.propertyMap.get(key);
        }
        return null;
    }

    private synchronized V synchronizedRemove(K key) {
        for (int i = 0; i < this.arrayCount; ++i) {
            if (!this.arrayEntries[i].getKey().equals(key)) continue;
            V removedProperty = this.arrayEntries[i].getValue();
            --this.arrayCount;
            System.arraycopy(this.arrayEntries, i + 1, this.arrayEntries, i, this.arrayCount - i);
            this.arrayEntries[this.arrayCount] = null;
            return removedProperty;
        }
        if (this.arrayCount == -1) {
            V value = this.propertyMap.remove(key);
            if (this.switchBackToArray && this.propertyMap.size() < this.toMapThreshold) {
                this.arrayEntries = new ArrayEntry[this.toMapThreshold];
                int tmpCount = 0;
                for (Map.Entry<K, V> entry : this.propertyMap.entrySet()) {
                    this.arrayEntries[tmpCount++] = new ArrayEntry<K, V>(entry.getKey(), entry.getValue());
                }
                this.propertyMap = null;
                this.arrayCount = tmpCount;
            }
            return value;
        }
        return null;
    }

    public V remove(K key) {
        if (this.useThreadSafeMap) {
            return this.synchronizedRemove(key);
        }
        for (int i = 0; i < this.arrayCount; ++i) {
            if (!this.arrayEntries[i].getKey().equals(key)) continue;
            V removedProperty = this.arrayEntries[i].getValue();
            --this.arrayCount;
            System.arraycopy(this.arrayEntries, i + 1, this.arrayEntries, i, this.arrayCount - i);
            this.arrayEntries[this.arrayCount] = null;
            return removedProperty;
        }
        if (this.arrayCount == -1) {
            V value = this.propertyMap.remove(key);
            if (this.switchBackToArray && this.propertyMap.size() < this.toMapThreshold) {
                this.arrayEntries = new ArrayEntry[this.toMapThreshold];
                int tmpCount = 0;
                for (Map.Entry<K, V> entry : this.propertyMap.entrySet()) {
                    this.arrayEntries[tmpCount++] = new ArrayEntry<K, V>(entry.getKey(), entry.getValue());
                }
                this.propertyMap = null;
                this.arrayCount = tmpCount;
            }
            return value;
        }
        return null;
    }

    public Iterable<K> keySet() {
        if (this.arrayCount == -1) {
            return this.propertyMap.keySet();
        }
        LinkedList<K> keys = new LinkedList<K>();
        for (int i = 0; i < this.arrayCount; ++i) {
            keys.add(this.arrayEntries[i].getKey());
        }
        return keys;
    }

    public Iterable<V> values() {
        if (this.arrayCount == -1) {
            return this.propertyMap.values();
        }
        LinkedList<V> values = new LinkedList<V>();
        for (int i = 0; i < this.arrayCount; ++i) {
            values.add(this.arrayEntries[i].getValue());
        }
        return values;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        if (this.arrayCount == -1) {
            return this.propertyMap.entrySet();
        }
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this.arrayCount; ++i) {
            entries.add(this.arrayEntries[i]);
        }
        return entries;
    }

    public int size() {
        if (this.arrayCount != -1) {
            return this.arrayCount;
        }
        return this.propertyMap.size();
    }

    public void clear() {
        if (this.useThreadSafeMap) {
            this.synchronizedClear();
            return;
        }
        if (this.arrayCount != -1) {
            Arrays.fill(this.arrayEntries, null);
            this.arrayCount = 0;
        } else {
            this.propertyMap.clear();
        }
    }

    private synchronized void synchronizedClear() {
        if (this.arrayCount != -1) {
            Arrays.fill(this.arrayEntries, null);
            this.arrayCount = 0;
        } else {
            this.propertyMap.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        ArrayEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        void setNewValue(V value) {
            this.value = value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = value;
            this.value = value;
            return oldValue;
        }
    }
}

