/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.neo4j.kernel.impl.transaction.xaframework.XaResource;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;

public abstract class XaResourceHelpImpl
implements XaResource {
    private int transactionTimeout = 120;
    private XaTransaction xaTx = null;
    private final XaResourceManager xaRm;
    private byte[] branchId = null;

    protected XaResourceHelpImpl(XaResourceManager xaRm, byte[] branchId) {
        this.xaRm = xaRm;
        this.branchId = branchId;
    }

    public XaTransaction getCompletedTx() {
        return this.xaTx;
    }

    public abstract boolean isSameRM(XAResource var1);

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xaTx = this.xaRm.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        if (flags == 0x4000000) {
            this.xaRm.end(this, xid);
        } else if (flags == 0x2000000) {
            this.xaRm.suspend(xid);
        } else if (flags == 0x20000000) {
            this.xaRm.fail(this, xid);
        }
    }

    public void forget(Xid xid) throws XAException {
        this.xaRm.forget(xid);
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public boolean setTransactionTimeout(int timeout) {
        this.transactionTimeout = timeout;
        return true;
    }

    public int prepare(Xid xid) throws XAException {
        return this.xaRm.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaRm.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.xaRm.rollback(xid);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.xaTx = null;
        if (flags == 0) {
            this.xaRm.start(this, xid);
        } else if (flags == 0x8000000) {
            this.xaRm.resume(xid);
        } else if (flags == 0x200000) {
            this.xaRm.join(this, xid);
        } else {
            throw new XAException("Unknown flag[" + flags + "]");
        }
    }

    public void setBranchId(byte[] branchId) {
        this.branchId = branchId;
    }

    public byte[] getBranchId() {
        return this.branchId;
    }
}

