/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.impl.core.NodeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeProxy
implements Node {
    private final NodeManager nm;
    private final int nodeId;

    NodeProxy(int nodeId, NodeManager nodeManager) {
        this.nodeId = nodeId;
        this.nm = nodeManager;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nm.getGraphDbService();
    }

    @Override
    public void delete() {
        this.nm.getNodeForProxy(this.nodeId).delete(this.nm);
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.nm.getNodeForProxy(this.nodeId).getRelationships(this.nm);
    }

    @Override
    public boolean hasRelationship() {
        return this.nm.getNodeForProxy(this.nodeId).hasRelationship(this.nm);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).getRelationships(this.nm, dir);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).hasRelationship(this.nm, dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.nm.getNodeForProxy(this.nodeId).getRelationships(this.nm, types);
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return this.nm.getNodeForProxy(this.nodeId).hasRelationship(this.nm, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).getRelationships(this.nm, type, dir);
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).hasRelationship(this.nm, type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).getSingleRelationship(this.nm, type, dir);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.nm.getNodeForProxy(this.nodeId).setProperty(this.nm, key, value);
    }

    @Override
    public Object removeProperty(String key) throws NotFoundException {
        return this.nm.getNodeForProxy(this.nodeId).removeProperty(this.nm, key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.nm.getNodeForProxy(this.nodeId).getProperty(this.nm, key, defaultValue);
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.nm.getNodeForProxy(this.nodeId).getPropertyValues(this.nm);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.nm.getNodeForProxy(this.nodeId).getPropertyKeys(this.nm);
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        return this.nm.getNodeForProxy(this.nodeId).getProperty(this.nm, key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.nm.getNodeForProxy(this.nodeId).hasProperty(this.nm, key);
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        return this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return this.nodeId;
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        return this.nm.getNodeForProxy(this.nodeId).createRelationshipTo(this.nm, otherNode, type);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        return this.nm.getNodeForProxy(this.nodeId).traverse(this.nm, traversalOrder, stopEvaluator, returnableEvaluator, relationshipType, direction);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        return this.nm.getNodeForProxy(this.nodeId).traverse(this.nm, traversalOrder, stopEvaluator, returnableEvaluator, firstRelationshipType, firstDirection, secondRelationshipType, secondDirection);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        return this.nm.getNodeForProxy(this.nodeId).traverse(this.nm, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }
}

