/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapUtil {
    public static <K, V> Map<K, V> genericMap(Object ... objects) {
        return MapUtil.genericMap(new HashMap(), objects);
    }

    public static <K, V> Map<K, V> genericMap(Map<K, V> targetMap, Object ... objects) {
        int i = 0;
        while (i < objects.length) {
            targetMap.put(objects[i++], objects[i++]);
        }
        return targetMap;
    }

    public static Map<String, String> stringMap(String ... strings) {
        return MapUtil.genericMap(strings);
    }

    public static Map<String, String> stringMap(Map<String, String> targetMap, String ... strings) {
        return MapUtil.genericMap(targetMap, (Object[])strings);
    }

    public static Map<String, Object> map(Object ... objects) {
        return MapUtil.genericMap(objects);
    }

    public static Map<String, Object> map(Map<String, Object> targetMap, Object ... objects) {
        return MapUtil.genericMap(targetMap, objects);
    }

    public static Map<String, String> load(Reader reader) throws IOException {
        Properties props = new Properties();
        props.load(reader);
        return new HashMap<Object, Object>(props);
    }

    public static Map<String, String> loadStrictly(Reader reader) {
        try {
            return MapUtil.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> load(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        return new HashMap<Object, Object>(props);
    }

    public static Map<String, String> loadStrictly(InputStream stream) {
        try {
            return MapUtil.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> load(File file) throws IOException {
        Map<String, String> map;
        block2: {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                map = MapUtil.load(stream);
                Object var4_3 = null;
                if (stream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (stream == null) break block3;
                    stream.close();
                }
                throw throwable;
            }
            stream.close();
        }
        return map;
    }

    public static Map<String, String> loadStrictly(File file) {
        try {
            return MapUtil.load(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

