/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyEventData;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Primitive {
    protected final int id;
    private ArrayMap<Integer, PropertyData> propertyMap = null;

    protected abstract void changeProperty(NodeManager var1, int var2, Object var3);

    protected abstract int addProperty(NodeManager var1, PropertyIndex var2, Object var3);

    protected abstract void removeProperty(NodeManager var1, int var2);

    protected abstract ArrayMap<Integer, PropertyData> loadProperties(NodeManager var1, boolean var2);

    Primitive(int id) {
        this.id = id;
    }

    Primitive(int id, boolean newPrimitive) {
        this.id = id;
        if (newPrimitive) {
            this.propertyMap = new ArrayMap(9, false, true);
        }
    }

    public long getId() {
        return this.id;
    }

    public Iterable<Object> getPropertyValues(NodeManager nodeManager) {
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        ArrayList<Object> values = new ArrayList<Object>();
        for (Integer index : this.propertyMap.keySet()) {
            if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
            values.add(this.propertyMap.get(index).getValue());
        }
        if (addMap != null) {
            for (PropertyData property : addMap.values()) {
                values.add(property.getValue());
            }
        }
        return values;
    }

    public Iterable<String> getPropertyKeys(NodeManager nodeManager) {
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        ArrayList<String> keys = new ArrayList<String>();
        for (Integer index : this.propertyMap.keySet()) {
            if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
            keys.add(nodeManager.getIndexFor(index).getKey());
        }
        if (addMap != null) {
            for (Integer index : addMap.keySet()) {
                keys.add(nodeManager.getIndexFor(index).getKey());
            }
        }
        return keys;
    }

    public Object getProperty(NodeManager nodeManager, String key) throws NotFoundException {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                throw this.newPropertyNotFoundException(key);
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return this.getPropertyValue(nodeManager, property);
            }
            property = this.propertyMap.get(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(nodeManager, property);
        }
        PropertyData property = this.getSlowProperty(nodeManager, addMap, skipMap, key);
        if (property != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        throw this.newPropertyNotFoundException(key);
    }

    private NotFoundException newPropertyNotFoundException(String key) {
        return new NotFoundException(key + " property not found for " + this + ".");
    }

    private PropertyData getSlowProperty(NodeManager nodeManager, ArrayMap<Integer, PropertyData> addMap, ArrayMap<Integer, PropertyData> skipMap, String key) {
        PropertyData property;
        PropertyIndex indexToCheck;
        if (nodeManager.hasAllPropertyIndexes()) {
            return null;
        }
        if (addMap != null) {
            for (int keyId : addMap.keySet()) {
                if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                if (skipMap != null && skipMap.get(keyId) != null) {
                    throw this.newPropertyNotFoundException(key);
                }
                property = addMap.get(indexToCheck.getKeyId());
                if (property == null) continue;
                return property;
            }
        }
        for (int keyId : this.propertyMap.keySet()) {
            if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
            if (skipMap != null && skipMap.get(keyId) != null) {
                throw this.newPropertyNotFoundException(key);
            }
            property = this.propertyMap.get(indexToCheck.getKeyId());
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public Object getProperty(NodeManager nodeManager, String key, Object defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                return defaultValue;
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return this.getPropertyValue(nodeManager, property);
            }
            property = this.propertyMap.get(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(nodeManager, property);
        }
        PropertyData property = this.getSlowProperty(nodeManager, addMap, skipMap, key);
        if (property != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        return defaultValue;
    }

    public boolean hasProperty(NodeManager nodeManager, String key) {
        if (key == null) {
            return false;
        }
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                return false;
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return true;
            }
            property = this.propertyMap.get(index.getKeyId());
            if (property == null) continue;
            return true;
        }
        PropertyData property = this.getSlowProperty(nodeManager, addMap, skipMap, key);
        return property != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(NodeManager nodeManager, String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null parameter, key=" + key + ", " + "value=" + value);
        }
        nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            this.ensureFullProperties(nodeManager);
            ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this, true);
            ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
            PropertyIndex index = null;
            PropertyData property = null;
            boolean foundInSkipMap = false;
            for (PropertyIndex cachedIndex : nodeManager.index(key)) {
                if (skipMap != null && skipMap.remove(cachedIndex.getKeyId()) != null) {
                    foundInSkipMap = true;
                }
                index = cachedIndex;
                property = addMap.get(cachedIndex.getKeyId());
                if (property == null && (property = this.propertyMap.get(cachedIndex.getKeyId())) == null) continue;
                break;
            }
            if (property == null && !nodeManager.hasAllPropertyIndexes()) {
                PropertyIndex indexToCheck;
                Iterator<Object> i$ = addMap.keySet().iterator();
                while (i$.hasNext()) {
                    int keyId = (Integer)i$.next();
                    if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                    if (skipMap != null) {
                        skipMap.remove(indexToCheck.getKeyId());
                    }
                    index = indexToCheck;
                    property = addMap.get(indexToCheck.getKeyId());
                    if (property == null) continue;
                    break;
                }
                if (property == null) {
                    i$ = this.propertyMap.keySet().iterator();
                    while (i$.hasNext()) {
                        int keyId = (Integer)i$.next();
                        if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                        if (skipMap != null) {
                            skipMap.remove(indexToCheck.getKeyId());
                        }
                        index = indexToCheck;
                        property = this.propertyMap.get(indexToCheck.getKeyId());
                        if (property == null) continue;
                        break;
                    }
                }
            }
            if (index == null) {
                index = nodeManager.createPropertyIndex(key);
            }
            if (property != null && !foundInSkipMap) {
                int propertyId = property.getId();
                this.changeProperty(nodeManager, propertyId, value);
                property = new PropertyData(propertyId, value);
            } else {
                int propertyId = this.addProperty(nodeManager, index, value);
                property = new PropertyData(propertyId, value);
            }
            addMap.put(index.getKeyId(), property);
            success = true;
        }
        finally {
            nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeProperty(NodeManager nodeManager, String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            Object object;
            this.ensureFullProperties(nodeManager);
            PropertyData property = null;
            ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
            ArrayMap<Integer, PropertyData> removeMap = nodeManager.getCowPropertyRemoveMap(this, true);
            for (PropertyIndex cachedIndex : nodeManager.index(key)) {
                if (addMap != null && (property = addMap.remove(cachedIndex.getKeyId())) != null) {
                    removeMap.put(cachedIndex.getKeyId(), property);
                    break;
                }
                if (removeMap.get(cachedIndex.getKeyId()) != null) {
                    success = true;
                    Object var9_11 = null;
                    return var9_11;
                }
                property = this.propertyMap.get(cachedIndex.getKeyId());
                if (property == null) continue;
                removeMap.put(cachedIndex.getKeyId(), property);
                break;
            }
            if (property == null && !nodeManager.hasAllPropertyIndexes() && addMap != null) {
                PropertyIndex indexToCheck;
                Iterator<Object> i$ = addMap.keySet().iterator();
                while (i$.hasNext()) {
                    int keyId = (Integer)i$.next();
                    if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key) || (property = addMap.remove(indexToCheck.getKeyId())) == null) continue;
                    removeMap.put(indexToCheck.getKeyId(), property);
                    break;
                }
                if (property == null) {
                    i$ = this.propertyMap.keySet().iterator();
                    while (i$.hasNext()) {
                        int keyId = (Integer)i$.next();
                        if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key) || (property = this.propertyMap.get(indexToCheck.getKeyId())) == null) continue;
                        removeMap.put(indexToCheck.getKeyId(), property);
                        break;
                    }
                }
            }
            if (property == null) {
                success = true;
                object = null;
                return object;
            }
            this.removeProperty(nodeManager, property.getId());
            success = true;
            object = this.getPropertyValue(nodeManager, property);
            return object;
        }
        finally {
            nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    private Object getPropertyValue(NodeManager nodeManager, PropertyData property) {
        Object value = property.getValue();
        if (value == null) {
            value = nodeManager.loadPropertyValue(property.getId());
            property.setNewValue(value);
        }
        return value;
    }

    protected void commitPropertyMaps(ArrayMap<Integer, PropertyData> cowPropertyAddMap, ArrayMap<Integer, PropertyData> cowPropertyRemoveMap) {
        if (this.propertyMap == null) {
            return;
        }
        if (cowPropertyAddMap != null) {
            for (Integer index : cowPropertyAddMap.keySet()) {
                this.propertyMap.put(index, cowPropertyAddMap.get(index));
            }
        }
        if (cowPropertyRemoveMap != null && this.propertyMap != null) {
            for (Integer index : cowPropertyRemoveMap.keySet()) {
                this.propertyMap.remove(index);
            }
        }
    }

    private boolean ensureFullProperties(NodeManager nodeManager) {
        if (this.propertyMap == null) {
            this.propertyMap = this.loadProperties(nodeManager, false);
            return true;
        }
        return false;
    }

    private boolean ensureFullLightProperties(NodeManager nodeManager) {
        if (this.propertyMap == null) {
            this.propertyMap = this.loadProperties(nodeManager, true);
            return true;
        }
        return false;
    }

    protected List<PropertyEventData> getAllCommittedProperties(NodeManager nodeManager) {
        this.ensureFullLightProperties(nodeManager);
        ArrayList<PropertyEventData> props = new ArrayList<PropertyEventData>(this.propertyMap.size());
        for (Map.Entry<Integer, PropertyData> entry : this.propertyMap.entrySet()) {
            PropertyIndex index = nodeManager.getIndexFor(entry.getKey());
            Object value = this.getPropertyValue(nodeManager, this.propertyMap.get(index.getKeyId()));
            props.add(new PropertyEventData(index.getKey(), value));
        }
        return props;
    }

    protected Object getCommittedPropertyValue(NodeManager nodeManager, String key) {
        this.ensureFullLightProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property = this.propertyMap.get(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(nodeManager, property);
        }
        return null;
    }
}

