/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;

public class MultiEvaluator
implements Evaluator {
    private final Evaluator[] evaluators;

    MultiEvaluator(Evaluator ... prunings) {
        this.evaluators = prunings;
    }

    public Evaluation evaluate(Path position) {
        boolean includes = true;
        boolean continues = true;
        for (Evaluator evaluator : this.evaluators) {
            Evaluation bla = evaluator.evaluate(position);
            if (!bla.includes()) {
                includes = false;
            }
            if (!bla.continues()) {
                continues = false;
            }
            if (continues || includes) continue;
            return Evaluation.EXCLUDE_AND_PRUNE;
        }
        return Evaluation.of(includes, continues);
    }

    public MultiEvaluator add(Evaluator evaluator) {
        Evaluator[] newArray = new Evaluator[this.evaluators.length + 1];
        System.arraycopy(this.evaluators, 0, newArray, 0, this.evaluators.length);
        newArray[newArray.length - 1] = evaluator;
        return new MultiEvaluator(newArray);
    }
}

