/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.osgi;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiExtensionLoader
implements BundleListener {
    private final BundleContext bc;
    private final ConcurrentMap<Long, BundleServiceProvider> providers = new ConcurrentHashMap<Long, BundleServiceProvider>();

    OSGiExtensionLoader(BundleContext bc) {
        this.bc = bc;
    }

    public <T> Iterable<T> loadExtensionsOfType(Class<T> type) {
        try {
            System.out.println("Kernel: attempting to load extensions of type " + type.getName());
            ServiceReference[] services = this.bc.getServiceReferences(type.getName(), null);
            if (services != null) {
                LinkedList<Object> serviceCollection = new LinkedList<Object>();
                for (ServiceReference sr : services) {
                    Object service = this.bc.getService(sr);
                    serviceCollection.add(service);
                }
                return serviceCollection;
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            System.out.println("Failed to load extensions of type: " + type);
            e.printStackTrace();
            return null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: 
            case 128: {
                this.started(event.getBundle());
                break;
            }
            case 256: {
                this.stopping(event.getBundle());
            }
        }
    }

    void started(Bundle bundle) {
        this.providers.putIfAbsent(bundle.getBundleId(), new BundleServiceProvider(bundle));
    }

    void stopping(Bundle bundle) {
        this.providers.remove(bundle.getBundleId());
    }

    private class BundleServiceProvider {
        private final Bundle bundle;

        BundleServiceProvider(Bundle bundle) {
            this.bundle = bundle;
        }
    }
}

