/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.nioneo.xa.WriteTransaction;
import org.neo4j.kernel.impl.persistence.IdGenerationFailedException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogBackedXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoStoreXaDataSource
extends LogBackedXaDataSource {
    private static final String REBUILD_IDGENERATORS_FAST = "rebuild_idgenerators_fast";
    private static Logger logger = Logger.getLogger(NeoStoreXaDataSource.class.getName());
    private final NeoStore neoStore;
    private final XaContainer xaContainer;
    private final ArrayMap<Class<?>, Store> idGenerators;
    private final LockManager lockManager;
    private final LockReleaser lockReleaser;
    private final String storeDir;
    private final boolean readOnly;
    private boolean backupSlave = false;
    private boolean logApplied = false;
    private final StringLogger msgLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeoStoreXaDataSource(Map<Object, Object> config) throws IOException, InstantiationException {
        super(config);
        this.readOnly = Boolean.parseBoolean((String)config.get("read_only"));
        this.backupSlave = Boolean.parseBoolean((String)config.get("backup_slave"));
        this.lockManager = (LockManager)config.get(LockManager.class);
        this.lockReleaser = (LockReleaser)config.get(LockReleaser.class);
        this.storeDir = (String)config.get("store_dir");
        this.msgLog = StringLogger.getLogger(this.storeDir + "/messages.log");
        String store = (String)config.get("neo_store");
        if (!config.containsKey(REBUILD_IDGENERATORS_FAST)) {
            config.put(REBUILD_IDGENERATORS_FAST, "true");
        }
        File file = new File(store);
        String create = "" + config.get("create");
        if (!this.readOnly && !file.exists() && "true".equals(create)) {
            this.msgLog.logMessage("Creating new db @ " + store, true);
            this.autoCreatePath(store);
            NeoStore.createStore(store, config);
        }
        this.neoStore = new NeoStore(config);
        this.xaContainer = XaContainer.create(this, (String)config.get("logical_log"), new CommandFactory(this.neoStore), new TransactionFactory(), config);
        if (!this.readOnly) {
            this.neoStore.setRecoveredStatus(true);
            try {
                this.xaContainer.openLogicalLog();
                Object var6_5 = null;
                this.neoStore.setRecoveredStatus(false);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.neoStore.setRecoveredStatus(false);
                throw throwable;
            }
        }
        if (!this.xaContainer.getResourceManager().hasRecoveredTransactions()) {
            this.neoStore.makeStoreOk();
        } else {
            logger.fine("Waiting for TM to take care of recovered transactions.");
        }
        this.idGenerators = new ArrayMap(5, false, false);
        this.idGenerators.put(Node.class, this.neoStore.getNodeStore());
        this.idGenerators.put(Relationship.class, this.neoStore.getRelationshipStore());
        this.idGenerators.put(RelationshipType.class, this.neoStore.getRelationshipTypeStore());
        this.idGenerators.put(PropertyStore.class, this.neoStore.getPropertyStore());
        this.idGenerators.put(PropertyIndex.class, this.neoStore.getPropertyStore().getIndexStore());
        this.xaContainer.getLogicalLog().setKeepLogs(this.shouldKeepLog((String)config.get("keep_logical_logs"), "nioneodb"));
        this.setLogicalLogAtCreationTime(this.xaContainer.getLogicalLog());
    }

    private void autoCreatePath(String store) throws IOException {
        String fileSeparator = System.getProperty("file.separator");
        int index = store.lastIndexOf(fileSeparator);
        String dirs = store.substring(0, index);
        File directories = new File(dirs);
        if (!directories.exists() && !directories.mkdirs()) {
            throw new IOException("Unable to create directory path[" + dirs + "] for Neo4j store.");
        }
    }

    NeoStore getNeoStore() {
        return this.neoStore;
    }

    @Override
    public void close() {
        if (!this.readOnly) {
            this.neoStore.flushAll();
        }
        this.xaContainer.close();
        if (this.logApplied) {
            this.neoStore.rebuildIdGenerators();
            this.logApplied = false;
        }
        this.neoStore.close();
        logger.fine("NeoStore closed");
        this.msgLog.logMessage("NeoStore closed", true);
    }

    @Override
    public XaConnection getXaConnection() {
        return new NeoStoreXaConnection(this.neoStore, this.xaContainer.getResourceManager(), this.getBranchId());
    }

    public int nextId(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.nextId();
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getHighestPossibleIdInUse();
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getNumberOfIdsInUse();
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    @Override
    public long getCreationTime() {
        return this.neoStore.getCreationTime();
    }

    @Override
    public long getRandomIdentifier() {
        return this.neoStore.getRandomNumber();
    }

    @Override
    public long getCurrentLogVersion() {
        return this.neoStore.getVersion();
    }

    public long incrementAndGetLogVersion() {
        return this.neoStore.incrementVersion();
    }

    public void setCurrentLogVersion(long version) {
        this.neoStore.setVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommittedTxId(long txId) {
        this.neoStore.setRecoveredStatus(true);
        try {
            this.neoStore.setLastCommittedTx(txId);
            Object var4_2 = null;
            this.neoStore.setRecoveredStatus(false);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.neoStore.setRecoveredStatus(false);
            throw throwable;
        }
    }

    @Override
    public void applyLog(ReadableByteChannel byteChannel) throws IOException {
        this.logApplied = true;
        super.applyLog(byteChannel);
    }

    ReadTransaction getReadOnlyTransaction() {
        return new ReadTransaction(this.neoStore);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public List<WindowPoolStats> getWindowPoolStats() {
        return this.neoStore.getAllWindowPoolStats();
    }

    @Override
    public long getLastCommittedTxId() {
        return this.neoStore.getLastCommittedTx();
    }

    @Override
    public XaContainer getXaContainer() {
        return this.xaContainer;
    }

    private class TransactionFactory
    extends XaTransactionFactory {
        TransactionFactory() {
        }

        public XaTransaction create(int identifier) {
            return new WriteTransaction(identifier, this.getLogicalLog(), NeoStoreXaDataSource.this.neoStore, NeoStoreXaDataSource.this.lockReleaser, NeoStoreXaDataSource.this.lockManager);
        }

        public void recoveryComplete() {
            logger.fine("Recovery complete, all transactions have been resolved");
            logger.fine("Rebuilding id generators as needed. This can take a while for large stores...");
            NeoStoreXaDataSource.this.neoStore.flushAll();
            NeoStoreXaDataSource.this.neoStore.makeStoreOk();
            logger.fine("Rebuild of id generators complete.");
        }

        public long getCurrentVersion() {
            if (this.getLogicalLog().scanIsComplete()) {
                return NeoStoreXaDataSource.this.neoStore.getVersion();
            }
            return NeoStoreXaDataSource.this.neoStore.getVersion();
        }

        public long getAndSetNewVersion() {
            return NeoStoreXaDataSource.this.neoStore.incrementVersion();
        }

        public void flushAll() {
            NeoStoreXaDataSource.this.neoStore.flushAll();
        }

        public long getLastCommittedTx() {
            return NeoStoreXaDataSource.this.neoStore.getLastCommittedTx();
        }
    }

    private static class CommandFactory
    extends XaCommandFactory {
        private NeoStore neoStore = null;

        CommandFactory(NeoStore neoStore) {
            this.neoStore = neoStore;
        }

        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            Command command = Command.readCommand(this.neoStore, byteChannel, buffer);
            if (command != null) {
                command.setRecovered();
            }
            return command;
        }
    }
}

