/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;

public abstract class Evaluators {
    private static final Evaluator ALL = new Evaluator(){

        public Evaluation evaluate(Path path) {
            return Evaluation.INCLUDE_AND_CONTINUE;
        }
    };
    private static final Evaluator ALL_BUT_START_POSITION = new Evaluator(){

        public Evaluation evaluate(Path path) {
            return path.length() == 0 ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_CONTINUE;
        }
    };

    public static Evaluator all() {
        return ALL;
    }

    public static Evaluator excludeStartPosition() {
        return ALL_BUT_START_POSITION;
    }

    public static Evaluator toDepth(final int depth) {
        return new Evaluator(){

            public Evaluation evaluate(Path path) {
                return path.length() < depth ? Evaluation.INCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_PRUNE;
            }
        };
    }

    public static Evaluator fromDepth(final int depth) {
        return new Evaluator(){

            public Evaluation evaluate(Path path) {
                return path.length() < depth ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_CONTINUE;
            }
        };
    }

    public static Evaluator atDepth(final int depth) {
        return new Evaluator(){

            public Evaluation evaluate(Path path) {
                return path.length() < depth ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_PRUNE;
            }
        };
    }

    public static Evaluator includingDepths(final int minDepth, final int maxDepth) {
        return new Evaluator(){

            public Evaluation evaluate(Path path) {
                int length = path.length();
                return Evaluation.of(length >= minDepth && length <= maxDepth, length < maxDepth);
            }
        };
    }
}

