/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;

public abstract class XaConnectionHelpImpl
implements XaConnection {
    private final XaResourceManager xaRm;

    public XaConnectionHelpImpl(XaResourceManager xaRm) {
        if (xaRm == null) {
            throw new IllegalArgumentException("XaResourceManager is null");
        }
        this.xaRm = xaRm;
    }

    public abstract XAResource getXaResource();

    public void destroy() {
        this.xaRm.destroy(this.getXaResource());
    }

    public void validate() throws XAException {
        this.xaRm.validate(this.getXaResource());
    }

    protected XaTransaction getTransaction() throws XAException {
        XAResource xar = this.getXaResource();
        XaTransaction xat = null;
        if (xar instanceof XaResourceHelpImpl) {
            xat = ((XaResourceHelpImpl)xar).getCompletedTx();
        }
        if (xat != null) {
            return xat;
        }
        return this.xaRm.getXaTransaction(xar);
    }

    public void clearAllTransactions() {
        this.xaRm.reset();
    }
}

