/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.nioneo.store.AbstractRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipTypeRecord
extends AbstractRecord {
    private int typeBlock = Record.NO_NEXT_BLOCK.intValue();
    private Map<Integer, DynamicRecord> typeRecords = new HashMap<Integer, DynamicRecord>();

    public RelationshipTypeRecord(int id) {
        super(id);
    }

    public DynamicRecord getTypeRecord(int blockId) {
        return this.typeRecords.get(blockId);
    }

    public void addTypeRecord(DynamicRecord record) {
        this.typeRecords.put(record.getId(), record);
    }

    public int getTypeBlock() {
        return this.typeBlock;
    }

    public void setTypeBlock(int typeBlock) {
        this.typeBlock = typeBlock;
    }

    public Collection<DynamicRecord> getTypeRecords() {
        return this.typeRecords.values();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RelationshipTypeRecord[").append(this.getId()).append(",").append(this.inUse()).append(",").append(this.typeBlock);
        buf.append(", blocks[");
        for (DynamicRecord record : this.typeRecords.values()) {
            buf.append(record);
        }
        buf.append("]]");
        return buf.toString();
    }
}

