/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IteratorUtil {
    public static <T> T firstOrNull(Iterator<T> iterator) {
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> T first(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.firstOrNull(iterator));
    }

    public static <T> T lastOrNull(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static <T> T last(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.lastOrNull(iterator));
    }

    public static <T> T singleOrNull(Iterator<T> iterator) {
        T result;
        T t = result = iterator.hasNext() ? (T)iterator.next() : null;
        if (iterator.hasNext()) {
            throw new NoSuchElementException("More than one element in " + iterator + ". First element is '" + result + "' and the element value is '" + iterator.next() + "'");
        }
        return result;
    }

    public static <T> T single(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.singleOrNull(iterator));
    }

    private static <T> T assertNotNull(Iterator<T> iterator, T result) {
        if (result == null) {
            throw new NoSuchElementException("No element found in " + iterator);
        }
        return result;
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        return IteratorUtil.firstOrNull(iterable.iterator());
    }

    public static <T> T first(Iterable<T> iterable) {
        return IteratorUtil.first(iterable.iterator());
    }

    public static <T> T lastOrNull(Iterable<T> iterable) {
        return IteratorUtil.lastOrNull(iterable.iterator());
    }

    public static <T> T last(Iterable<T> iterable) {
        return IteratorUtil.last(iterable.iterator());
    }

    public static <T> T singleOrNull(Iterable<T> iterable) {
        return IteratorUtil.singleOrNull(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable) {
        return IteratorUtil.single(iterable.iterator());
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterable<T> iterable, C collection) {
        return IteratorUtil.addToCollection(iterable.iterator(), collection);
    }

    public static <T> Iterable<T> asIterable(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <T> int count(Iterator<T> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++result;
        }
        return result;
    }

    public static <T> int count(Iterable<T> iterable) {
        return IteratorUtil.count(iterable.iterator());
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        ArrayList list = new ArrayList();
        IteratorUtil.addToCollection(iterable, list);
        return list;
    }
}

