/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.FilteringIterable;
import org.neo4j.helpers.collection.PrefetchingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterator<T>
extends PrefetchingIterator<T> {
    private final Iterator<T> source;
    private final Predicate<T> predicate;

    public FilteringIterator(Iterator<T> source, Predicate<T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected T fetchNextOrNull() {
        while (this.source.hasNext()) {
            T testItem = this.source.next();
            if (!this.predicate.accept(testItem)) continue;
            return testItem;
        }
        return null;
    }

    public static <T> Iterator<T> notNull(Iterator<T> source) {
        return new FilteringIterator<T>(source, FilteringIterable.notNullPredicate());
    }

    public static <T> Iterator<T> noDuplicates(Iterator<T> source) {
        return new FilteringIterator<T>(source, FilteringIterable.noDuplicatesPredicate());
    }
}

