/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipStore
extends AbstractStore
implements Store {
    private static final String VERSION = "RelationshipStore v0.9.5";
    private static final int RECORD_SIZE = 33;

    public RelationshipStore(String fileName, Map<?, ?> config) {
        super(fileName, config, IdType.RELATIONSHIP);
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 33;
    }

    @Override
    public void close() {
        super.close();
    }

    public static void createStore(String fileName, IdGeneratorFactory idGeneratorFactory) {
        RelationshipStore.createEmptyStore(fileName, VERSION, idGeneratorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRecord getRecord(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            RelationshipRecord record;
            RelationshipRecord relationshipRecord = record = this.getRecord(id, window, false);
            return relationshipRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRecord getLightRel(int id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return null;
        }
        try {
            RelationshipRecord record;
            RelationshipRecord relationshipRecord = record = this.getRecord(id, window, true);
            return relationshipRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(RelationshipRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(RelationshipRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    private void updateRecord(RelationshipRecord record, PersistenceWindow window) {
        int id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            byte inUse = Record.IN_USE.byteValue();
            buffer.put(inUse).putInt(record.getFirstNode()).putInt(record.getSecondNode()).putInt(record.getType()).putInt(record.getFirstPrevRel()).putInt(record.getFirstNextRel()).putInt(record.getSecondPrevRel()).putInt(record.getSecondNextRel()).putInt(record.getNextProp());
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    private RelationshipRecord getRecord(int id, PersistenceWindow window, boolean check) {
        boolean inUseFlag;
        Buffer buffer = window.getOffsettedBuffer(id);
        byte inUse = buffer.get();
        boolean bl = inUseFlag = (inUse & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue();
        if (!inUseFlag) {
            if (check) {
                return null;
            }
            throw new InvalidRecordException("Record[" + id + "] not in use");
        }
        RelationshipRecord record = new RelationshipRecord(id, buffer.getInt(), buffer.getInt(), buffer.getInt());
        record.setInUse(inUseFlag);
        record.setFirstPrevRel(buffer.getInt());
        record.setFirstNextRel(buffer.getInt());
        record.setSecondPrevRel(buffer.getInt());
        record.setSecondNextRel(buffer.getInt());
        record.setNextProp(buffer.getInt());
        return record;
    }

    private RelationshipRecord getFullRecord(int id, PersistenceWindow window) {
        Buffer buffer = window.getOffsettedBuffer(id);
        byte inUse = buffer.get();
        boolean inUseFlag = (inUse & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue();
        RelationshipRecord record = new RelationshipRecord(id, buffer.getInt(), buffer.getInt(), buffer.getInt());
        record.setInUse(inUseFlag);
        record.setFirstPrevRel(buffer.getInt());
        record.setFirstNextRel(buffer.getInt());
        record.setSecondPrevRel(buffer.getInt());
        record.setSecondNextRel(buffer.getInt());
        record.setNextProp(buffer.getInt());
        return record;
    }

    public String toString() {
        return "RelStore";
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("RelationshipStore")) {
            return false;
        }
        if (version.equals("RelationshipStore v0.9.3")) {
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRecord getChainRecord(int relId) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(relId, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return null;
        }
        try {
            RelationshipRecord relationshipRecord = this.getFullRecord(relId, window);
            return relationshipRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.getWindowPoolStats());
        return list;
    }
}

