/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.management;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.management.CacheBean;
import org.neo4j.kernel.impl.management.Configuration;
import org.neo4j.kernel.impl.management.Description;
import org.neo4j.kernel.impl.management.KernelBean;
import org.neo4j.kernel.impl.management.LockManagerBean;
import org.neo4j.kernel.impl.management.MemoryMappingBean;
import org.neo4j.kernel.impl.management.PrimitivesBean;
import org.neo4j.kernel.impl.management.StoreFileBean;
import org.neo4j.kernel.impl.management.TransactionManagerBean;
import org.neo4j.kernel.impl.management.XaManagerBean;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4jMBean
extends StandardMBean {
    private static final Logger log;
    private static final ProxyMaker PROXY_MAKER;
    private static final boolean SUPPORT_MX_BEAN;
    private final ObjectName objectName;

    public static Runnable initMBeans(Creator creator) {
        Factory jmx = new Factory(ManagementFactory.getPlatformMBeanServer(), creator);
        creator.create(jmx);
        jmx.createKernelMBean(creator.kernelVersion);
        return new JmxShutdown(jmx.beans);
    }

    public static <T> T getBean(String instanceId, Class<T> beanType) {
        if (beanType.isInterface() && (beanType.getPackage().getName().equals("org.neo4j.kernel.management") || beanType == DynamicMBean.class)) {
            if (PROXY_MAKER == null) {
                throw new UnsupportedOperationException("Creating Management Bean proxies requires Java 1.6");
            }
            ObjectName name = Neo4jMBean.getObjectName(instanceId, beanType, Configuration.class);
            return PROXY_MAKER.makeProxy(name, beanType);
        }
        throw new IllegalArgumentException("Not a Neo4j management bean: " + beanType);
    }

    private static Neo4jMBean registerBean(MBeanServer mbs, Neo4jMBean bean) {
        try {
            mbs.registerMBean(bean, bean.objectName);
            return bean;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void failedToRegister(String mBean) {
        log.info("Failed to register " + mBean);
    }

    private static void unregisterBean(MBeanServer mbs, Neo4jMBean bean) {
        try {
            mbs.unregisterMBean(bean.objectName);
        }
        catch (Exception e) {
            log.warning("Failed to unregister JMX Bean " + bean);
            e.printStackTrace();
        }
    }

    static <T extends Neo4jMBean> T createMX(MXFactory<T> factory) {
        if (SUPPORT_MX_BEAN) {
            return factory.createMXBean();
        }
        return factory.createMBean();
    }

    protected Neo4jMBean(String instanceId, Class<?> mbeanIface, boolean isMXBean) {
        super(mbeanIface, isMXBean);
        this.objectName = Neo4jMBean.getObjectName(instanceId, mbeanIface, this.getClass());
        if (this.objectName == null) {
            throw new IllegalArgumentException("");
        }
    }

    protected Neo4jMBean(String instanceId, Class<?> mbeanIface) throws NotCompliantMBeanException {
        super(mbeanIface);
        this.objectName = Neo4jMBean.getObjectName(instanceId, mbeanIface, this.getClass());
        if (this.objectName == null) {
            throw new IllegalArgumentException("");
        }
    }

    protected Neo4jMBean(String instanceId) throws NotCompliantMBeanException {
        super(DynamicMBean.class);
        this.objectName = Neo4jMBean.getObjectName(instanceId, DynamicMBean.class, this.getClass());
    }

    private static ObjectName getObjectName(String instanceId, Class<?> iface, Class<?> clazz) {
        String name;
        if (iface == null) {
            name = "*";
        } else if (iface == DynamicMBean.class) {
            name = clazz.getSimpleName();
        } else {
            try {
                name = (String)iface.getField("NAME").get(null);
            }
            catch (Exception e) {
                return null;
            }
        }
        StringBuilder identifier = new StringBuilder("org.neo4j:");
        identifier.append("instance=kernel#");
        identifier.append(instanceId);
        identifier.append(",name=");
        identifier.append(name);
        try {
            return new ObjectName(identifier.toString());
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        Description description = this.getClass().getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        Description description = this.describeMethod(info, "get", "is");
        if (description != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        Description description = this.describeMethod(info, new String[0]);
        if (description != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected int getImpact(MBeanOperationInfo info) {
        Description description = this.describeMethod(info, new String[0]);
        if (description != null) {
            return description.impact();
        }
        return super.getImpact(info);
    }

    private Description describeMethod(MBeanFeatureInfo info, String ... prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            try {
                return this.getClass().getMethod(info.getName(), new Class[0]).getAnnotation(Description.class);
            }
            catch (Exception e) {
                return null;
            }
        }
        for (String prefix : prefixes) {
            try {
                return this.getClass().getMethod(prefix + info.getName(), new Class[0]).getAnnotation(Description.class);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    static {
        ProxyMaker proxyMaker;
        log = Logger.getLogger(Neo4jMBean.class.getName());
        try {
            proxyMaker = new Java6ProxyMaker();
        }
        catch (Exception t) {
            proxyMaker = null;
        }
        catch (LinkageError t) {
            proxyMaker = null;
        }
        if (proxyMaker == null) {
            try {
                proxyMaker = new Java5ProxyMaker();
            }
            catch (Exception t) {
                proxyMaker = null;
            }
            catch (LinkageError t) {
                proxyMaker = null;
            }
        }
        PROXY_MAKER = proxyMaker;
        SUPPORT_MX_BEAN = proxyMaker != null && proxyMaker.supportsMxBean;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class MXFactory<T extends Neo4jMBean> {
        MXFactory() {
        }

        abstract T createStandardMBean() throws NotCompliantMBeanException;

        abstract T createMXBean();

        final T createMBean() {
            try {
                return this.createStandardMBean();
            }
            catch (NotCompliantMBeanException cause) {
                throw new IllegalArgumentException(cause);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Java5ProxyMaker
    extends ProxyMaker {
        Java5ProxyMaker() throws Exception {
            super(false);
            Class.forName("javax.management.MBeanServerInvocationHandler");
        }

        @Override
        <T> T makeProxy(ObjectName name, Class<T> beanType) {
            return MBeanServerInvocationHandler.newProxyInstance(ManagementFactory.getPlatformMBeanServer(), name, beanType, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Java6ProxyMaker
    extends ProxyMaker {
        private final Method isMXBeanInterface;
        private final Method newMBeanProxy;
        private final Method newMXBeanProxy;

        Java6ProxyMaker() throws Exception {
            super(true);
            Class<?> JMX = Class.forName("javax.management.JMX");
            this.isMXBeanInterface = JMX.getMethod("isMXBeanInterface", Class.class);
            this.newMBeanProxy = JMX.getMethod("newMBeanProxy", MBeanServerConnection.class, ObjectName.class, Class.class);
            this.newMXBeanProxy = JMX.getMethod("newMXBeanProxy", MBeanServerConnection.class, ObjectName.class, Class.class);
        }

        @Override
        <T> T makeProxy(ObjectName name, Class<T> beanType) {
            try {
                Method factoryMethod = this.isMXBeanInterface(beanType) ? this.newMXBeanProxy : this.newMBeanProxy;
                return beanType.cast(factoryMethod.invoke(null, ManagementFactory.getPlatformMBeanServer(), name, beanType));
            }
            catch (InvocationTargetException exception) {
                throw Java6ProxyMaker.launderRuntimeException(exception.getTargetException());
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException("Creating Management Bean proxies requires Java 1.6", exception);
            }
        }

        private boolean isMXBeanInterface(Class<?> interfaceClass) throws Exception {
            return (Boolean)this.isMXBeanInterface.invoke(null, interfaceClass);
        }

        static RuntimeException launderRuntimeException(Throwable exception) {
            if (exception instanceof RuntimeException) {
                return (RuntimeException)exception;
            }
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            throw new RuntimeException("Unexpected Exception!", exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ProxyMaker {
        final boolean supportsMxBean;

        ProxyMaker(boolean supportsMxBean) {
            this.supportsMxBean = supportsMxBean;
        }

        abstract <T> T makeProxy(ObjectName var1, Class<T> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JmxShutdown
    implements Runnable {
        private final Neo4jMBean[] beans;

        public JmxShutdown(List<Neo4jMBean> beans) {
            this.beans = beans.toArray(new Neo4jMBean[beans.size()]);
        }

        @Override
        public void run() {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            for (Neo4jMBean bean : this.beans) {
                Neo4jMBean.unregisterBean(mbs, bean);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory {
        private final MBeanServer mbs;
        private final Creator instance;
        private final List<Neo4jMBean> beans = new ArrayList<Neo4jMBean>();

        private Factory(MBeanServer mbs, Creator creator) {
            this.mbs = mbs;
            this.instance = creator;
        }

        private void createKernelMBean(final String kernelVersion) {
            if (!this.register((Callable<? extends Neo4jMBean>)new Callable<KernelBean>(){

                @Override
                public KernelBean call() throws Exception {
                    return new KernelBean(Factory.this.instance.id, kernelVersion, Factory.this.instance.datasource, Neo4jMBean.getObjectName(Factory.this.instance.id, null, null));
                }
            })) {
                Neo4jMBean.failedToRegister("KernelBean");
            }
        }

        public void createPrimitiveMBean(final NodeManager nodeManager) {
            if (!this.register((Callable<? extends Neo4jMBean>)new Callable<PrimitivesBean>(){

                @Override
                public PrimitivesBean call() throws NotCompliantMBeanException {
                    return new PrimitivesBean(Factory.this.instance.id, nodeManager);
                }
            })) {
                Neo4jMBean.failedToRegister("PrimitiveMBean");
            }
        }

        public void createCacheMBean(final NodeManager nodeManager) {
            if (!this.register((Callable<? extends Neo4jMBean>)new Callable<CacheBean>(){

                @Override
                public CacheBean call() throws NotCompliantMBeanException {
                    return new CacheBean(Factory.this.instance.id, nodeManager);
                }
            })) {
                Neo4jMBean.failedToRegister("CacheMBean");
            }
        }

        public void createDynamicConfigurationMBean(final Map<Object, Object> params) {
            if (!this.register((Callable<? extends Neo4jMBean>)new Callable<Neo4jMBean>(){

                @Override
                public Neo4jMBean call() throws NotCompliantMBeanException {
                    return new Configuration(Factory.this.instance.id, params);
                }
            })) {
                Neo4jMBean.failedToRegister("ConfigurationMBean");
            }
        }

        public void createMemoryMappingMBean(XaDataSourceManager datasourceMananger) {
            final NeoStoreXaDataSource datasource = (NeoStoreXaDataSource)datasourceMananger.getXaDataSource("nioneodb");
            if (!this.register((Callable<? extends Neo4jMBean>)new Callable<Neo4jMBean>(){

                @Override
                public Neo4jMBean call() {
                    return MemoryMappingBean.create(Factory.this.instance.id, datasource);
                }
            })) {
                Neo4jMBean.failedToRegister("MemoryMappingMBean");
            }
        }

        public void createXaManagerMBean(final XaDataSourceManager datasourceMananger) {
            if (!this.register((Callable<? extends Neo4jMBean>)new Callable<Neo4jMBean>(){

                @Override
                public Neo4jMBean call() {
                    return XaManagerBean.create(Factory.this.instance.id, datasourceMananger);
                }
            })) {
                Neo4jMBean.failedToRegister("XaManagerMBean");
            }
        }

        public void createTransactionManagerMBean(final TxModule txModule) {
            if (!this.register((Callable<? extends Neo4jMBean>)new Callable<TransactionManagerBean>(){

                @Override
                public TransactionManagerBean call() throws NotCompliantMBeanException {
                    return new TransactionManagerBean(Factory.this.instance.id, txModule);
                }
            })) {
                Neo4jMBean.failedToRegister("TransactionManagerMBean");
            }
        }

        public void createLockManagerMBean(final LockManager lockManager) {
            if (!this.register((Callable<? extends Neo4jMBean>)new Callable<LockManagerBean>(){

                @Override
                public LockManagerBean call() throws NotCompliantMBeanException {
                    return new LockManagerBean(Factory.this.instance.id, lockManager);
                }
            })) {
                Neo4jMBean.failedToRegister("LockManagerMBean");
            }
        }

        public void createStoreFileMBean() {
            File path;
            try {
                path = new File(this.instance.datasource.getStoreDir()).getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                path = new File(this.instance.datasource.getStoreDir()).getAbsoluteFile();
            }
            final File storePath = path;
            if (!this.register((Callable<? extends Neo4jMBean>)new Callable<StoreFileBean>(){

                @Override
                public StoreFileBean call() throws NotCompliantMBeanException {
                    return new StoreFileBean(Factory.this.instance.id, storePath);
                }
            })) {
                Neo4jMBean.failedToRegister("StoreFileMBean");
            }
        }

        private boolean register(Callable<? extends Neo4jMBean> beanFactory) {
            Neo4jMBean bean;
            try {
                bean = beanFactory.call();
            }
            catch (Exception e) {
                return false;
            }
            bean = Neo4jMBean.registerBean(this.mbs, bean);
            if (bean != null) {
                this.beans.add(bean);
                return true;
            }
            return false;
        }
    }

    public static abstract class Creator {
        private final String id;
        private final String kernelVersion;
        private final NeoStoreXaDataSource datasource;

        protected Creator(String instanceId, String kernelVersion, NeoStoreXaDataSource datasource) {
            if (kernelVersion == null || datasource == null) {
                throw new IllegalArgumentException("null valued argument");
            }
            this.id = instanceId;
            this.kernelVersion = kernelVersion;
            this.datasource = datasource;
        }

        protected abstract void create(Factory var1);
    }
}

