/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Iterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.PruneEvaluator;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.PostorderBreadthFirstSelector;
import org.neo4j.kernel.PostorderDepthFirstSelector;
import org.neo4j.kernel.PreorderBreadthFirstSelector;
import org.neo4j.kernel.PreorderDepthFirstSelector;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.impl.traversal.FinalTraversalBranch;
import org.neo4j.kernel.impl.traversal.TraversalDescriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Traversal {
    private static final BranchOrderingPolicy PREORDER_DEPTH_FIRST_SELECTOR = new BranchOrderingPolicy(){

        public BranchSelector create(TraversalBranch startSource) {
            return new PreorderDepthFirstSelector(startSource);
        }
    };
    private static final BranchOrderingPolicy POSTORDER_DEPTH_FIRST_SELECTOR = new BranchOrderingPolicy(){

        public BranchSelector create(TraversalBranch startSource) {
            return new PostorderDepthFirstSelector(startSource);
        }
    };
    private static final BranchOrderingPolicy PREORDER_BREADTH_FIRST_SELECTOR = new BranchOrderingPolicy(){

        public BranchSelector create(TraversalBranch startSource) {
            return new PreorderBreadthFirstSelector(startSource);
        }
    };
    private static final BranchOrderingPolicy POSTORDER_BREADTH_FIRST_SELECTOR = new BranchOrderingPolicy(){

        public BranchSelector create(TraversalBranch startSource) {
            return new PostorderBreadthFirstSelector(startSource);
        }
    };
    private static final Predicate<Path> RETURN_ALL = new Predicate<Path>(){

        @Override
        public boolean accept(Path item) {
            return true;
        }
    };
    private static final Predicate<Path> RETURN_ALL_BUT_START_NODE = new Predicate<Path>(){

        @Override
        public boolean accept(Path item) {
            return item.length() > 0;
        }
    };

    public static TraversalDescription description() {
        return new TraversalDescriptionImpl();
    }

    public static Expander expanderForTypes(RelationshipType type, Direction dir) {
        return StandardExpander.create(type, dir);
    }

    public static Expander emptyExpander() {
        return StandardExpander.DEFAULT;
    }

    public static Expander expanderForTypes(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2) {
        return StandardExpander.create(type1, dir1, type2, dir2);
    }

    public static Expander expanderForTypes(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2, Object ... more) {
        return StandardExpander.create(type1, dir1, type2, dir2, more);
    }

    public static Expander expanderForAllTypes() {
        return Traversal.expanderForAllTypes(Direction.BOTH);
    }

    public static Expander expanderForAllTypes(Direction direction) {
        return StandardExpander.create(direction);
    }

    public static Expander expander(RelationshipExpander expander) {
        if (expander instanceof Expander) {
            return (Expander)expander;
        }
        return StandardExpander.wrap(expander);
    }

    public static TraversalBranch combineSourcePaths(TraversalBranch source, TraversalBranch target) {
        if (!source.node().equals(target.node())) {
            throw new IllegalArgumentException("The nodes of the head and tail must match");
        }
        Path headPath = source.position();
        Path tailPath = target.position();
        Relationship[] relationships = new Relationship[headPath.length() + tailPath.length()];
        Iterator<Relationship> iter = headPath.relationships().iterator();
        int i = 0;
        while (iter.hasNext()) {
            relationships[i] = iter.next();
            ++i;
        }
        iter = tailPath.relationships().iterator();
        i = relationships.length - 1;
        while (iter.hasNext()) {
            relationships[i] = iter.next();
            --i;
        }
        return new FinalTraversalBranch(tailPath.startNode(), relationships);
    }

    public static PruneEvaluator pruneAfterDepth(final int depth) {
        return new PruneEvaluator(){

            public boolean pruneAfter(Path position) {
                return position.length() >= depth;
            }
        };
    }

    public static Predicate<Path> returnAll() {
        return RETURN_ALL;
    }

    public static Predicate<Path> returnAcceptedByAny(final Predicate<Path> ... filters) {
        return new Predicate<Path>(){

            @Override
            public boolean accept(Path item) {
                for (Predicate filter : filters) {
                    if (!filter.accept(item)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Path> returnAllButStartNode() {
        return RETURN_ALL_BUT_START_NODE;
    }

    public static BranchOrderingPolicy preorderDepthFirst() {
        return PREORDER_DEPTH_FIRST_SELECTOR;
    }

    public static BranchOrderingPolicy postorderDepthFirst() {
        return POSTORDER_DEPTH_FIRST_SELECTOR;
    }

    public static BranchOrderingPolicy preorderBreadthFirst() {
        return PREORDER_BREADTH_FIRST_SELECTOR;
    }

    public static BranchOrderingPolicy postorderBreadthFirst() {
        return POSTORDER_BREADTH_FIRST_SELECTOR;
    }

    public static <T extends Path> String pathToString(T path, PathDescriptor<T> builder) {
        Node current = path.startNode();
        StringBuilder result = new StringBuilder();
        for (Relationship rel : path.relationships()) {
            result.append(builder.nodeRepresentation(path, current));
            result.append(builder.relationshipRepresentation(path, current, rel));
            current = rel.getOtherNode(current);
        }
        result.append(builder.nodeRepresentation(path, current));
        return result.toString();
    }

    public static String defaultPathToString(Path path) {
        return Traversal.pathToString(path, new DefaultPathDescriptor());
    }

    public static String simplePathToString(Path path) {
        return Traversal.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static String simplePathToString(Path path, final String nodePropertyKey) {
        return Traversal.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String nodeRepresentation(Path path, Node node) {
                return "(" + node.getProperty(nodePropertyKey, node.getId()) + ")";
            }

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static Predicate<Path> returnWhereLastRelationshipTypeIs(final RelationshipType firstRelationshipType, final RelationshipType ... relationshipTypes) {
        return new Predicate<Path>(){

            @Override
            public boolean accept(Path p) {
                Relationship lastRel = p.lastRelationship();
                if (lastRel == null) {
                    return false;
                }
                if (lastRel.isType(firstRelationshipType)) {
                    return true;
                }
                for (RelationshipType currentType : relationshipTypes) {
                    if (!lastRel.isType(currentType)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultPathDescriptor<T extends Path>
    implements PathDescriptor<T> {
        @Override
        public String nodeRepresentation(Path path, Node node) {
            return "(" + node.getId() + ")";
        }

        @Override
        public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
            String prefix = "--";
            String suffix = "--";
            if (from.equals(relationship.getEndNode())) {
                prefix = "<--";
            } else {
                suffix = "-->";
            }
            return prefix + "[" + relationship.getType().name() + "," + relationship.getId() + "]" + suffix;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PathDescriptor<T extends Path> {
        public String nodeRepresentation(T var1, Node var2);

        public String relationshipRepresentation(T var1, Node var2, Relationship var3);
    }
}

