/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PostorderBreadthFirstSelector
implements BranchSelector {
    private Iterator<TraversalBranch> sourceIterator;
    private TraversalBranch current;

    PostorderBreadthFirstSelector(TraversalBranch startSource) {
        this.current = startSource;
    }

    @Override
    public TraversalBranch next() {
        if (this.sourceIterator == null) {
            this.sourceIterator = this.gatherSourceIterator();
        }
        return this.sourceIterator.hasNext() ? this.sourceIterator.next() : null;
    }

    private Iterator<TraversalBranch> gatherSourceIterator() {
        List<TraversalBranch> level;
        LinkedList<TraversalBranch> queue = new LinkedList<TraversalBranch>();
        queue.add(this.current.next());
        while (!(level = this.gatherOneLevel(queue)).isEmpty()) {
            queue.addAll(0, level);
        }
        return queue.iterator();
    }

    private List<TraversalBranch> gatherOneLevel(List<TraversalBranch> queue) {
        LinkedList<TraversalBranch> level = new LinkedList<TraversalBranch>();
        Integer depth = null;
        for (TraversalBranch source : queue) {
            TraversalBranch next;
            if (depth == null) {
                depth = source.depth();
            } else if (source.depth() != depth.intValue()) break;
            while ((next = source.next()) != null) {
                level.add(next);
            }
        }
        return level;
    }
}

