/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<T1, T2> {
    private final T1 first;
    private final T2 other;

    public Pair(T1 first, T2 other) {
        this.first = first;
        this.other = other;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 other) {
        return new Pair<T1, T2>(first, other);
    }

    public T1 first() {
        return this.first;
    }

    public T2 other() {
        return this.other;
    }

    public String toString() {
        return "(" + this.first + ", " + this.other + ")";
    }

    public int hashCode() {
        return 31 * Pair.hashCode(this.first) | Pair.hashCode(this.other);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pair) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return this.pairEquals((Pair)obj);
        }
        return false;
    }

    boolean pairEquals(Pair that) {
        return Pair.equals(this.first, that.first) && Pair.equals(this.other, that.other);
    }

    static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    static boolean equals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }
}

