/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.management;

import java.util.Iterator;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import org.neo4j.kernel.impl.management.Description;
import org.neo4j.kernel.impl.management.Neo4jMBean;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.management.MemoryMapping;
import org.neo4j.kernel.management.WindowPoolInfo;

@Description(value="The status of Neo4j memory mapping")
class MemoryMappingBean
extends Neo4jMBean
implements MemoryMapping {
    private final NeoStoreXaDataSource datasource;

    static MemoryMappingBean create(final String instanceId, final NeoStoreXaDataSource datasource) {
        return MemoryMappingBean.createMX(new Neo4jMBean.MXFactory<MemoryMappingBean>(){

            @Override
            MemoryMappingBean createMXBean() {
                return new MemoryMappingBean(instanceId, datasource, true);
            }

            @Override
            MemoryMappingBean createStandardMBean() throws NotCompliantMBeanException {
                return new MemoryMappingBean(instanceId, datasource);
            }
        });
    }

    private MemoryMappingBean(String instanceId, NeoStoreXaDataSource datasource) throws NotCompliantMBeanException {
        super(instanceId, MemoryMapping.class);
        this.datasource = datasource;
    }

    private MemoryMappingBean(String instanceId, NeoStoreXaDataSource datasource, boolean isMXBean) {
        super(instanceId, MemoryMapping.class, isMXBean);
        this.datasource = datasource;
    }

    @Description(value="Get information about each pool of memory mapped regions from store files with memory mapping enabled")
    public WindowPoolInfo[] getMemoryPools() {
        return MemoryMappingBean.getMemoryPoolsImpl(this.datasource);
    }

    public static WindowPoolInfo[] getMemoryPoolsImpl(NeoStoreXaDataSource datasource) {
        List<WindowPoolStats> stats = datasource.getWindowPoolStats();
        WindowPoolInfo[] pools = new WindowPoolInfo[stats.size()];
        Iterator iter = stats.iterator();
        int index = 0;
        while (iter.hasNext()) {
            pools[index] = MemoryMappingBean.createWindowPoolInfo((WindowPoolStats)iter.next());
            ++index;
        }
        return pools;
    }

    private static WindowPoolInfo createWindowPoolInfo(WindowPoolStats stats) {
        return new WindowPoolInfo(stats.getName(), stats.getMemAvail(), stats.getMemUsed(), stats.getWindowCount(), stats.getWindowSize(), stats.getHitCount(), stats.getMissCount(), stats.getOomCount());
    }
}

