/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.kernel.impl.core.FastRelTypeElement;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;
import org.neo4j.kernel.impl.util.IntArray;

class RelTypeElement
extends RelTypeElementIterator {
    private final IntArray src;
    private final IntArray add;
    private final Set<Integer> remove = new HashSet<Integer>();
    private boolean srcTraversed = false;
    private boolean addTraversed = false;
    private int position = 0;
    private Integer nextElement = null;

    static RelTypeElementIterator create(String type, NodeImpl node, IntArray src, IntArray add, IntArray remove) {
        if (add == null && remove == null) {
            return new FastRelTypeElement(type, node, src);
        }
        return new RelTypeElement(type, node, src, add, remove);
    }

    private RelTypeElement(String type, NodeImpl node, IntArray src, IntArray add, IntArray remove) {
        super(type, node);
        this.src = src;
        if (src == null) {
            this.srcTraversed = true;
        }
        if (add == null) {
            this.addTraversed = true;
        }
        this.add = add;
        if (remove != null) {
            for (int i = 0; i < remove.length(); ++i) {
                this.remove.add(remove.get(i));
            }
        }
    }

    public boolean hasNext(NodeManager nodeManager) {
        int value;
        if (this.nextElement != null) {
            return true;
        }
        while (!this.addTraversed && this.position < this.add.length()) {
            value = this.add.get(this.position++);
            if (this.position >= this.add.length()) {
                this.addTraversed = true;
                this.position = 0;
            }
            if (this.remove.contains(value)) continue;
            this.nextElement = value;
            return true;
        }
        while (!this.srcTraversed) {
            if (this.position >= this.src.length()) {
                while (this.getNode().getMoreRelationships(nodeManager) && this.position >= this.src.length()) {
                }
                if (this.position >= this.src.length()) {
                    this.srcTraversed = true;
                    this.position = 0;
                    return false;
                }
            }
            if (this.remove.contains(value = this.src.get(this.position++))) continue;
            this.nextElement = value;
            return true;
        }
        return false;
    }

    public int next(NodeManager nodeManager) {
        this.hasNext(nodeManager);
        if (this.nextElement != null) {
            Integer elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

