/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.TransactionDataImpl;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.IntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockReleaser {
    private static Logger log = Logger.getLogger(LockReleaser.class.getName());
    private final ArrayMap<Transaction, List<LockElement>> lockMap = new ArrayMap(5, true, true);
    private final ArrayMap<Transaction, PrimitiveElement> cowMap = new ArrayMap(5, true, true);
    private NodeManager nodeManager;
    private final LockManager lockManager;
    private final TransactionManager transactionManager;
    private PropertyIndexManager propertyIndexManager;

    public LockReleaser(LockManager lockManager, TransactionManager transactionManager) {
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
    }

    void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    void setPropertyIndexManager(PropertyIndexManager propertyIndexManager) {
        this.propertyIndexManager = propertyIndexManager;
    }

    public void addLockToTransaction(Object resource, LockType type) throws NotInTransactionException {
        Transaction tx = this.getTransaction();
        List<LockElement> lockElements = this.lockMap.get(tx);
        if (lockElements != null) {
            lockElements.add(new LockElement(resource, type));
        } else {
            if (tx == null) {
                if (type == LockType.WRITE) {
                    this.lockManager.releaseWriteLock(resource);
                } else if (type == LockType.READ) {
                    this.lockManager.releaseReadLock(resource);
                }
                return;
            }
            lockElements = new ArrayList<LockElement>();
            this.lockMap.put(tx, lockElements);
            lockElements.add(new LockElement(resource, type));
            try {
                tx.registerSynchronization((Synchronization)new ReadOnlyTxReleaser(tx));
            }
            catch (Exception e) {
                throw new TransactionFailureException("Failed to register lock release synchronization hook", e);
            }
        }
    }

    private Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Failed to get current transaction.", e);
        }
    }

    public IntArray getCowRelationshipRemoveMap(NodeImpl node, String type) {
        ArrayMap<Integer, CowNodeElement> cowElements;
        CowNodeElement element;
        PrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && (element = (cowElements = primitiveElement.nodes).get(node.id)) != null && element.relationshipRemoveMap != null) {
            return element.relationshipRemoveMap.get(type);
        }
        return null;
    }

    public IntArray getCowRelationshipRemoveMap(NodeImpl node, String type, boolean create) {
        IntArray set;
        if (!create) {
            return this.getCowRelationshipRemoveMap(node, type);
        }
        PrimitiveElement primitiveElement = this.getAndSetupPrimitiveElement();
        ArrayMap<Integer, CowNodeElement> cowElements = primitiveElement.nodes;
        CowNodeElement element = cowElements.get(node.id);
        if (element == null) {
            element = new CowNodeElement();
            cowElements.put(node.id, element);
        }
        if (element.relationshipRemoveMap == null) {
            element.relationshipRemoveMap = new ArrayMap();
        }
        if ((set = element.relationshipRemoveMap.get(type)) == null) {
            set = new IntArray();
            element.relationshipRemoveMap.put(type, set);
        }
        return set;
    }

    public ArrayMap<String, IntArray> getCowRelationshipAddMap(NodeImpl node) {
        ArrayMap<Integer, CowNodeElement> cowElements;
        CowNodeElement element;
        PrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && (element = (cowElements = primitiveElement.nodes).get(node.id)) != null) {
            return element.relationshipAddMap;
        }
        return null;
    }

    public IntArray getCowRelationshipAddMap(NodeImpl node, String type) {
        ArrayMap<Integer, CowNodeElement> cowElements;
        CowNodeElement element;
        PrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && (element = (cowElements = primitiveElement.nodes).get(node.id)) != null && element.relationshipAddMap != null) {
            return element.relationshipAddMap.get(type);
        }
        return null;
    }

    public IntArray getCowRelationshipAddMap(NodeImpl node, String type, boolean create) {
        IntArray set;
        if (!create) {
            return this.getCowRelationshipRemoveMap(node, type);
        }
        PrimitiveElement primitiveElement = this.getAndSetupPrimitiveElement();
        ArrayMap<Integer, CowNodeElement> cowElements = primitiveElement.nodes;
        CowNodeElement element = cowElements.get(node.id);
        if (element == null) {
            element = new CowNodeElement();
            cowElements.put(node.id, element);
        }
        if (element.relationshipAddMap == null) {
            element.relationshipAddMap = new ArrayMap();
        }
        if ((set = element.relationshipAddMap.get(type)) == null) {
            set = new IntArray();
            element.relationshipAddMap.put(type, set);
        }
        return set;
    }

    public void commit() {
        Transaction tx = this.getTransaction();
        this.propertyIndexManager.commit(tx);
        this.releaseCows(tx, 3);
        this.releaseLocks(tx);
    }

    public void rollback() {
        Transaction tx = this.getTransaction();
        this.propertyIndexManager.rollback(tx);
        this.releaseCows(tx, 4);
        this.releaseLocks(tx);
    }

    void releaseLocks(Transaction tx) {
        List<LockElement> lockElements = this.lockMap.remove(tx);
        if (lockElements != null) {
            for (LockElement lockElement : lockElements) {
                try {
                    if (lockElement.lockType == LockType.READ) {
                        this.lockManager.releaseReadLock(lockElement.resource);
                        continue;
                    }
                    if (lockElement.lockType != LockType.WRITE) continue;
                    this.lockManager.releaseWriteLock(lockElement.resource);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.severe("Unable to release lock[" + (Object)((Object)lockElement.lockType) + "] on resource[" + lockElement.resource + "]");
                }
            }
        }
    }

    void releaseCows(Transaction cowTxId, int param) {
        PrimitiveElement element = this.cowMap.remove(cowTxId);
        if (element == null) {
            return;
        }
        ArrayMap<Integer, CowNodeElement> cowNodeElements = element.nodes;
        Set<Map.Entry<Integer, CowNodeElement>> nodeEntrySet = cowNodeElements.entrySet();
        for (Map.Entry<Integer, CowNodeElement> entry : nodeEntrySet) {
            NodeImpl node = this.nodeManager.getNodeIfCached(entry.getKey());
            if (node == null) continue;
            CowNodeElement nodeElement = entry.getValue();
            if (param == 3) {
                node.commitRelationshipMaps(nodeElement.relationshipAddMap, nodeElement.relationshipRemoveMap);
                node.commitPropertyMaps(nodeElement.propertyAddMap, nodeElement.propertyRemoveMap);
                continue;
            }
            if (param == 4) continue;
            throw new TransactionFailureException("Unknown transaction status: " + param);
        }
        ArrayMap<Integer, CowRelElement> cowRelElements = element.relationships;
        Set<Map.Entry<Integer, CowRelElement>> relEntrySet = cowRelElements.entrySet();
        for (Map.Entry<Integer, CowRelElement> entry : relEntrySet) {
            RelationshipImpl rel = this.nodeManager.getRelIfCached(entry.getKey());
            if (rel == null) continue;
            CowRelElement relElement = entry.getValue();
            if (param == 3) {
                rel.commitPropertyMaps(relElement.propertyAddMap, relElement.propertyRemoveMap);
                continue;
            }
            if (param == 4) continue;
            throw new TransactionFailureException("Unknown transaction status: " + param);
        }
        this.cowMap.remove(cowTxId);
    }

    public synchronized void dumpLocks() {
        System.out.print("Locks held: ");
        Iterator<Transaction> itr = this.lockMap.keySet().iterator();
        if (!itr.hasNext()) {
            System.out.println("NONE");
        } else {
            System.out.println();
        }
        while (itr.hasNext()) {
            Transaction transaction = itr.next();
            System.out.println("" + transaction + "->" + this.lockMap.get(transaction).size());
        }
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(Primitive primitive) {
        ArrayMap<Integer, CowRelElement> cowElements;
        CowRelElement element;
        PrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && primitive instanceof NodeImpl) {
            ArrayMap<Integer, CowNodeElement> cowElements2 = primitiveElement.nodes;
            CowNodeElement element2 = cowElements2.get(primitive.id);
            if (element2 != null) {
                if (element2.deleted) {
                    throw new IllegalStateException("Node[" + primitive.id + "] has been deleted in this tx");
                }
                return element2.propertyRemoveMap;
            }
        } else if (primitiveElement != null && primitive instanceof RelationshipImpl && (element = (cowElements = primitiveElement.relationships).get(primitive.id)) != null) {
            if (element.deleted) {
                throw new IllegalStateException("Relationship[" + primitive.id + "] has been deleted in this tx");
            }
            return element.propertyRemoveMap;
        }
        return null;
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(Primitive primitive) {
        ArrayMap<Integer, CowRelElement> cowElements;
        CowRelElement element;
        PrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && primitive instanceof NodeImpl) {
            ArrayMap<Integer, CowNodeElement> cowElements2 = primitiveElement.nodes;
            CowNodeElement element2 = cowElements2.get(primitive.id);
            if (element2 != null) {
                if (element2.deleted) {
                    throw new IllegalStateException("Node[" + primitive.id + "] has been deleted in this tx");
                }
                return element2.propertyAddMap;
            }
        } else if (primitiveElement != null && primitive instanceof RelationshipImpl && (element = (cowElements = primitiveElement.relationships).get(primitive.id)) != null) {
            if (element.deleted) {
                throw new IllegalStateException("Relationship[" + primitive.id + "] has been deleted in this tx");
            }
            return element.propertyAddMap;
        }
        return null;
    }

    private PrimitiveElement getAndSetupPrimitiveElement() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        PrimitiveElement primitiveElement = this.cowMap.get(tx);
        if (primitiveElement == null) {
            primitiveElement = new PrimitiveElement();
            this.cowMap.put(tx, primitiveElement);
        }
        return primitiveElement;
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(Primitive primitive, boolean create) {
        if (!create) {
            return this.getCowPropertyAddMap(primitive);
        }
        PrimitiveElement primitiveElement = this.getAndSetupPrimitiveElement();
        if (primitive instanceof NodeImpl) {
            ArrayMap<Integer, CowNodeElement> cowElements = primitiveElement.nodes;
            CowNodeElement element = cowElements.get(primitive.id);
            if (element != null && element.deleted) {
                throw new IllegalStateException("Node[" + primitive.id + "] has been deleted in this tx");
            }
            if (element == null) {
                element = new CowNodeElement();
                cowElements.put(primitive.id, element);
            }
            if (element.propertyAddMap == null) {
                element.propertyAddMap = new ArrayMap();
            }
            return element.propertyAddMap;
        }
        if (primitive instanceof RelationshipImpl) {
            ArrayMap<Integer, CowRelElement> cowElements = primitiveElement.relationships;
            CowRelElement element = cowElements.get(primitive.id);
            if (element != null && element.deleted) {
                throw new IllegalStateException("Relationship[" + primitive.id + "] has been deleted in this tx");
            }
            if (element == null) {
                element = new CowRelElement();
                cowElements.put(primitive.id, element);
            }
            if (element.propertyAddMap == null) {
                element.propertyAddMap = new ArrayMap();
            }
            return element.propertyAddMap;
        }
        return null;
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(Primitive primitive, boolean create) {
        if (!create) {
            return this.getCowPropertyRemoveMap(primitive);
        }
        PrimitiveElement primitiveElement = this.getAndSetupPrimitiveElement();
        if (primitive instanceof NodeImpl) {
            ArrayMap<Integer, CowNodeElement> cowElements = primitiveElement.nodes;
            CowNodeElement element = cowElements.get(primitive.id);
            if (element != null && element.deleted) {
                throw new IllegalStateException("Node[" + primitive.id + "] has been deleted in this tx");
            }
            if (element == null) {
                element = new CowNodeElement();
                cowElements.put(primitive.id, element);
            }
            if (element.propertyRemoveMap == null) {
                element.propertyRemoveMap = new ArrayMap();
            }
            return element.propertyRemoveMap;
        }
        if (primitive instanceof RelationshipImpl) {
            ArrayMap<Integer, CowRelElement> cowElements = primitiveElement.relationships;
            CowRelElement element = cowElements.get(primitive.id);
            if (element != null && element.deleted) {
                throw new IllegalStateException("Relationship[" + primitive.id + "] has been deleted in this tx");
            }
            if (element == null) {
                element = new CowRelElement();
                cowElements.put(primitive.id, element);
            }
            if (element.propertyRemoveMap == null) {
                element.propertyRemoveMap = new ArrayMap();
            }
            return element.propertyRemoveMap;
        }
        return null;
    }

    public void deletePrimitive(Primitive primitive) {
        PrimitiveElement primitiveElement = this.getAndSetupPrimitiveElement();
        if (primitive instanceof NodeImpl) {
            ArrayMap<Integer, CowNodeElement> cowElements = primitiveElement.nodes;
            CowNodeElement element = cowElements.get(primitive.id);
            if (element != null && element.deleted) {
                throw new IllegalStateException("Node[" + primitive.id + "] has already been deleted in this tx");
            }
            if (element == null) {
                element = new CowNodeElement();
                cowElements.put(primitive.id, element);
            }
            element.deleted = true;
        } else if (primitive instanceof RelationshipImpl) {
            ArrayMap<Integer, CowRelElement> cowElements = primitiveElement.relationships;
            CowRelElement element = cowElements.get(primitive.id);
            if (element != null && element.deleted) {
                throw new IllegalStateException("Relationship[" + primitive.id + "] has already been deleted in this tx");
            }
            if (element == null) {
                element = new CowRelElement();
                cowElements.put(primitive.id, element);
            }
            element.deleted = true;
        }
    }

    public void removeNodeFromCache(int nodeId) {
        if (this.nodeManager != null) {
            this.nodeManager.removeNodeFromCache(nodeId);
        }
    }

    public void addRelationshipType(RelationshipTypeData type) {
        if (this.nodeManager != null) {
            this.nodeManager.addRelationshipType(type);
        }
    }

    public void addPropertyIndex(PropertyIndexData index) {
        if (this.nodeManager != null) {
            this.nodeManager.addPropertyIndex(index);
        }
    }

    public void removeRelationshipFromCache(int id) {
        if (this.nodeManager != null) {
            this.nodeManager.removeRelationshipFromCache(id);
        }
    }

    public void removeRelationshipTypeFromCache(int id) {
        if (this.nodeManager != null) {
            this.nodeManager.removeRelationshipTypeFromCache(id);
        }
    }

    public void clearCache() {
        if (this.nodeManager != null) {
            this.nodeManager.clearCache();
        }
    }

    public TransactionData getTransactionData() {
        TransactionDataImpl result = new TransactionDataImpl();
        PrimitiveElement element = this.cowMap.get(this.getTransaction());
        this.populateCreatedNodes(element, result);
        if (element == null) {
            return result;
        }
        if (element.nodes != null) {
            this.populateNodeRelEvent(element, result);
        }
        if (element.relationships != null) {
            this.populateRelationshipPropertyEvents(element, result);
        }
        return result;
    }

    private void populateRelationshipPropertyEvents(PrimitiveElement element, TransactionDataImpl result) {
        for (int relId : element.relationships.keySet()) {
            Object oldValue;
            String key;
            CowRelElement relElement = element.relationships.get(relId);
            RelationshipProxy rel = new RelationshipProxy(relId, this.nodeManager);
            RelationshipImpl relImpl = this.nodeManager.getRelForProxy(relId);
            if (relElement.deleted && this.nodeManager.relCreated(relId)) continue;
            if (relElement.propertyAddMap != null && !relElement.deleted) {
                for (PropertyData data : relElement.propertyAddMap.values()) {
                    key = this.nodeManager.getKeyForProperty(data.getId());
                    oldValue = relImpl.getCommittedPropertyValue(this.nodeManager, key);
                    Object newValue = data.getValue();
                    result.assignedProperty(rel, key, newValue, oldValue);
                }
            }
            if (relElement.propertyRemoveMap == null) continue;
            for (PropertyData data : relElement.propertyRemoveMap.values()) {
                key = this.nodeManager.getKeyForProperty(data.getId());
                oldValue = data.getValue();
                if (oldValue != null && !relElement.deleted) {
                    relImpl.getCommittedPropertyValue(this.nodeManager, key);
                }
                result.removedProperty(rel, key, oldValue);
            }
        }
    }

    private void populateNodeRelEvent(PrimitiveElement element, TransactionDataImpl result) {
        for (int nodeId : element.nodes.keySet()) {
            String key;
            int relId;
            int i;
            CowNodeElement nodeElement = element.nodes.get(nodeId);
            NodeProxy node = new NodeProxy(nodeId, this.nodeManager);
            NodeImpl nodeImpl = this.nodeManager.getNodeForProxy(nodeId);
            if (nodeElement.deleted) {
                if (this.nodeManager.nodeCreated(nodeId)) continue;
                result.deleted(node);
            }
            if (nodeElement.relationshipAddMap != null && !nodeElement.deleted) {
                for (String type : nodeElement.relationshipAddMap.keySet()) {
                    IntArray createdRels = nodeElement.relationshipAddMap.get(type);
                    for (i = 0; i < createdRels.length(); ++i) {
                        RelationshipProxy rel;
                        relId = createdRels.get(i);
                        CowRelElement relElement = element.relationships.get(relId);
                        if (relElement != null && relElement.deleted || (rel = new RelationshipProxy(relId, this.nodeManager)).getStartNode().getId() != (long)nodeId) continue;
                        result.created(new RelationshipProxy(relId, this.nodeManager));
                    }
                }
            }
            if (nodeElement.relationshipRemoveMap != null) {
                for (String type : nodeElement.relationshipRemoveMap.keySet()) {
                    IntArray deletedRels = nodeElement.relationshipRemoveMap.get(type);
                    for (i = 0; i < deletedRels.length(); ++i) {
                        RelationshipProxy rel;
                        relId = deletedRels.get(i);
                        if (this.nodeManager.relCreated(relId) || (rel = new RelationshipProxy(relId, this.nodeManager)).getStartNode().getId() != (long)nodeId) continue;
                        result.deleted(new RelationshipProxy(relId, this.nodeManager));
                    }
                }
            }
            if (nodeElement.propertyAddMap != null && !nodeElement.deleted) {
                for (PropertyData data : nodeElement.propertyAddMap.values()) {
                    key = this.nodeManager.getKeyForProperty(data.getId());
                    Object oldValue = nodeImpl.getCommittedPropertyValue(this.nodeManager, key);
                    Object newValue = data.getValue();
                    result.assignedProperty(node, key, newValue, oldValue);
                }
            }
            if (nodeElement.propertyRemoveMap == null) continue;
            for (PropertyData data : nodeElement.propertyRemoveMap.values()) {
                key = this.nodeManager.getKeyForProperty(data.getId());
                Object oldValue = data.getValue();
                if (oldValue == null && !nodeElement.deleted) {
                    nodeImpl.getCommittedPropertyValue(this.nodeManager, key);
                }
                result.removedProperty(node, key, oldValue);
            }
        }
    }

    private void populateCreatedNodes(PrimitiveElement element, TransactionDataImpl result) {
        IntArray createdNodes = this.nodeManager.getCreatedNodes();
        for (int i = 0; i < createdNodes.length(); ++i) {
            CowNodeElement nodeElement;
            int nodeId = createdNodes.get(i);
            if (element != null && element.nodes != null && (nodeElement = element.nodes.get(nodeId)) != null && nodeElement.deleted) continue;
            result.created(new NodeProxy(nodeId, this.nodeManager));
        }
    }

    private class ReadOnlyTxReleaser
    implements Synchronization {
        private final Transaction tx;

        ReadOnlyTxReleaser(Transaction tx) {
            this.tx = tx;
        }

        public void afterCompletion(int status) {
            LockReleaser.this.releaseLocks(this.tx);
        }

        public void beforeCompletion() {
        }
    }

    private static class LockElement {
        Object resource;
        LockType lockType;

        LockElement(Object resource, LockType type) {
            this.resource = resource;
            this.lockType = type;
        }
    }

    private static class CowRelElement {
        boolean deleted = false;
        ArrayMap<Integer, PropertyData> propertyAddMap = null;
        ArrayMap<Integer, PropertyData> propertyRemoveMap = null;

        CowRelElement() {
        }
    }

    private static class CowNodeElement {
        boolean deleted = false;
        ArrayMap<String, IntArray> relationshipAddMap = null;
        ArrayMap<String, IntArray> relationshipRemoveMap = null;
        ArrayMap<Integer, PropertyData> propertyAddMap = null;
        ArrayMap<Integer, PropertyData> propertyRemoveMap = null;

        CowNodeElement() {
        }
    }

    private static class PrimitiveElement {
        final ArrayMap<Integer, CowNodeElement> nodes = new ArrayMap();
        final ArrayMap<Integer, CowRelElement> relationships = new ArrayMap();

        PrimitiveElement() {
        }
    }
}

