/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NullRelTypeElement;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntArrayIterator
implements Iterable<Relationship>,
Iterator<Relationship> {
    private Iterator<RelTypeElementIterator> typeIterator;
    private RelTypeElementIterator currentTypeIterator = null;
    private final NodeImpl fromNode;
    private final Direction direction;
    private Relationship nextElement = null;
    private final NodeManager nodeManager;
    private final RelationshipType[] types;
    private final Set<String> visitedTypes = new HashSet<String>();

    IntArrayIterator(List<RelTypeElementIterator> rels, NodeImpl fromNode, Direction direction, NodeManager nodeManager, RelationshipType[] types) {
        this.typeIterator = rels.iterator();
        if (this.typeIterator.hasNext()) {
            this.currentTypeIterator = this.typeIterator.next();
            this.visitedTypes.add(this.currentTypeIterator.getType());
        } else {
            this.currentTypeIterator = new NullRelTypeElement();
        }
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
        this.types = types;
    }

    @Override
    public Iterator<Relationship> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement != null) {
            return true;
        }
        block2: do {
            if (this.currentTypeIterator.hasNext(this.nodeManager)) {
                int nextId = this.currentTypeIterator.next(this.nodeManager);
                try {
                    Relationship possibleElement = this.nodeManager.getRelationshipById(nextId);
                    if (this.direction == Direction.INCOMING && possibleElement.getEndNode().getId() == (long)this.fromNode.id) {
                        this.nextElement = possibleElement;
                        return true;
                    }
                    if (this.direction == Direction.OUTGOING && possibleElement.getStartNode().getId() == (long)this.fromNode.id) {
                        this.nextElement = possibleElement;
                        return true;
                    }
                    if (this.direction == Direction.BOTH) {
                        this.nextElement = possibleElement;
                        return true;
                    }
                }
                catch (NotFoundException e) {
                    // empty catch block
                }
            }
            while (!this.currentTypeIterator.hasNext(this.nodeManager)) {
                if (this.typeIterator.hasNext()) {
                    this.currentTypeIterator = this.typeIterator.next();
                    this.visitedTypes.add(this.currentTypeIterator.getType());
                    continue;
                }
                boolean gotMore = this.fromNode.getMoreRelationships(this.nodeManager);
                List<RelTypeElementIterator> list = Collections.EMPTY_LIST;
                list = this.types.length == 0 ? this.fromNode.getAllRelationships(this.nodeManager) : this.fromNode.getAllRelationshipsOfType(this.nodeManager, this.types);
                Iterator<RelTypeElementIterator> itr = list.iterator();
                while (itr.hasNext()) {
                    RelTypeElementIterator element = itr.next();
                    if (!this.visitedTypes.contains(element.getType())) continue;
                    itr.remove();
                }
                this.typeIterator = list.iterator();
                if (this.typeIterator.hasNext()) {
                    this.currentTypeIterator = this.typeIterator.next();
                    this.visitedTypes.add(this.currentTypeIterator.getType());
                }
                if (gotMore) continue;
                continue block2;
            }
        } while (this.currentTypeIterator.hasNext(this.nodeManager));
        return false;
    }

    @Override
    public Relationship next() {
        this.hasNext();
        if (this.nextElement != null) {
            Relationship elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

