/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KernelExtension
extends Service {
    private static final String INSTANCE_ID = "instanceId";

    protected KernelExtension(String key) {
        super(key, new String[0]);
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    public final boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass());
    }

    public final void agentLoad(String agentArgs) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String arg : agentArgs.split(";")) {
            String[] parts = arg.split("=", 2);
            if (parts.length == 2) {
                arg = parts[0].trim();
                if (INSTANCE_ID.equalsIgnoreCase(arg)) {
                    arg = INSTANCE_ID;
                }
                parameters.put(arg, parts[1]);
                continue;
            }
            parameters.put(arg.trim(), null);
        }
        KernelData kernel = KernelData.getInstance(parameters);
        if (kernel == null) {
            throw new IllegalStateException("could not load kernel");
        }
        kernel.extraParameters.putAll(parameters);
        this.load(kernel);
    }

    protected abstract void load(KernelData var1);

    protected void unload(KernelData kernel) {
    }

    protected boolean isLoaded(KernelData kernel) {
        return kernel.getState(this) != null;
    }

    protected <T> Function<T> function(KernelData kernel, String name, Class<T> result, Class<?> ... params) {
        Method method;
        Class[] parameters = new Class[params == null ? 1 : params.length + 1];
        parameters[0] = KernelData.class;
        if (params != null && params.length != 0) {
            System.arraycopy(params, 0, parameters, 1, params.length);
        }
        try {
            method = this.getClass().getMethod(name, parameters);
            if (!Modifier.isPublic(method.getModifiers())) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return new Function(result, kernel, method);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Function<T> {
        private final Class<T> type;
        private final KernelData kernel;
        private final Method method;

        private Function(Class<T> type, KernelData kernel, Method method) {
            this.type = type;
            this.kernel = kernel;
            this.method = method;
        }

        public T call(Object ... args) {
            Object[] arguments = new Object[args == null ? 1 : args.length + 1];
            arguments[0] = this.kernel;
            if (args != null && args.length > 0) {
                System.arraycopy(args, 0, arguments, 1, args.length);
            }
            try {
                return this.type.cast(this.method.invoke((Object)KernelExtension.this, arguments));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Access denied", e);
            }
            catch (InvocationTargetException e) {
                Throwable exception = e.getTargetException();
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                throw new RuntimeException("Unexpected exception: " + exception.getClass(), exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class KernelData {
        private static final Map<String, KernelData> instances = new HashMap<String, KernelData>();
        private static int ID_COUNTER = 0;
        private final Map<String, String> extraParameters = new HashMap<String, String>();
        private final String instanceId;
        private final Map<KernelExtension, Object> state = new HashMap<KernelExtension, Object>();

        private static synchronized String newInstance(KernelData instance) {
            String instanceId = Integer.toString(ID_COUNTER++);
            instances.put(instanceId, instance);
            return instanceId;
        }

        private static synchronized KernelData getInstance(Map<String, String> parameters) {
            String instanceId = parameters.remove(KernelExtension.INSTANCE_ID);
            if (instanceId != null) {
                return instances.get(instanceId);
            }
            if (instances.size() == 1) {
                return instances.values().iterator().next();
            }
            return null;
        }

        private static synchronized void removeInstance(String instanceId) {
            instances.remove(instanceId);
        }

        KernelData() {
            this.instanceId = KernelData.newInstance(this);
        }

        public final String instanceId() {
            return this.instanceId;
        }

        public final int hashCode() {
            return this.instanceId.hashCode();
        }

        public final boolean equals(Object obj) {
            return obj instanceof KernelData && this.instanceId.equals(((KernelData)obj).instanceId);
        }

        public abstract String version();

        public abstract Config getConfig();

        public abstract GraphDatabaseService graphDatabase();

        public abstract Map<Object, Object> getConfigParams();

        void startup(Logger log) {
            for (KernelExtension extension : Service.load(KernelExtension.class)) {
                try {
                    extension.load(this);
                }
                catch (Exception ex) {
                    log.warning("Error loading " + extension + ": " + ex);
                }
            }
        }

        synchronized void shutdown(Logger log) {
            for (KernelExtension loaded : this.state.keySet()) {
                try {
                    loaded.unload(this);
                }
                catch (Exception ex) {
                    log.warning("Error unloading " + loaded + ": " + ex);
                }
            }
            KernelData.removeInstance(this.instanceId);
        }

        public final Object getState(KernelExtension extension) {
            return this.state.get(extension);
        }

        public final Object setState(KernelExtension extension, Object value) {
            if (value == null) {
                return this.state.remove(extension);
            }
            return this.state.put(extension, value);
        }

        public final Object getParam(String key) {
            if (this.extraParameters.containsKey(key)) {
                return this.extraParameters.get(key);
            }
            return this.getConfigParams().get(key);
        }
    }
}

