/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class SimpleMetaDataProvider
implements MetadataProvider {
    private final SimpleTransactionIdStore transactionIdStore;
    private final SimpleLogVersionRepository logVersionRepository;
    private final ExternalStoreId externalStoreId = new ExternalStoreId(UUID.randomUUID());

    public SimpleMetaDataProvider() {
        this.transactionIdStore = new SimpleTransactionIdStore();
        this.logVersionRepository = new SimpleLogVersionRepository();
    }

    public void close() throws IOException {
    }

    public long getCurrentLogVersion() {
        return this.logVersionRepository.getCurrentLogVersion();
    }

    public void setCurrentLogVersion(long version) {
        this.logVersionRepository.setCurrentLogVersion(version);
    }

    public long incrementAndGetVersion() {
        return this.logVersionRepository.incrementAndGetVersion();
    }

    public long getCheckpointLogVersion() {
        return this.logVersionRepository.getCheckpointLogVersion();
    }

    public void setCheckpointLogVersion(long version) {
        this.logVersionRepository.setCheckpointLogVersion(version);
    }

    public long incrementAndGetCheckpointLogVersion() {
        return this.logVersionRepository.incrementAndGetCheckpointLogVersion();
    }

    public StoreId getStoreId() {
        return new StoreId(1L, 1L, "engine-1", "format-1", 1, 1);
    }

    public ExternalStoreId getExternalStoreId() {
        return this.externalStoreId;
    }

    public long nextCommittingTransactionId() {
        return this.transactionIdStore.nextCommittingTransactionId();
    }

    public long committingTransactionId() {
        return this.transactionIdStore.committingTransactionId();
    }

    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, long consensusIndex) {
        this.transactionIdStore.transactionCommitted(transactionId, checksum, commitTimestamp, consensusIndex);
    }

    public long getLastCommittedTransactionId() {
        return this.transactionIdStore.getLastCommittedTransactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.transactionIdStore.getLastCommittedTransaction();
    }

    public long getLastClosedTransactionId() {
        return this.transactionIdStore.getLastClosedTransactionId();
    }

    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        return this.transactionIdStore.getClosedTransactionSnapshot();
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        return this.transactionIdStore.getLastClosedTransaction();
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long consensusIndex, long byteOffset, long logVersion) {
        this.transactionIdStore.setLastCommittedAndClosedTransactionId(transactionId, checksum, commitTimestamp, consensusIndex, byteOffset, logVersion);
    }

    public void transactionClosed(long transactionId, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.transactionIdStore.transactionClosed(transactionId, logVersion, byteOffset, checksum, commitTimestamp, consensusIndex);
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.transactionIdStore.resetLastClosedTransaction(transactionId, logVersion, byteOffset, checksum, commitTimestamp, consensusIndex);
    }

    public Optional<UUID> getDatabaseIdUuid(CursorContext cursorContext) {
        throw new IllegalStateException("Not supported");
    }

    public void setDatabaseIdUuid(UUID uuid, CursorContext cursorContext) {
        throw new IllegalStateException("Not supported");
    }

    public void regenerateMetadata(StoreId storeId, UUID externalStoreUUID, CursorContext cursorContext) {
        throw new UnsupportedOperationException("RegenerateMetadata is not supported.");
    }
}

