/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public final class TestDatabaseReferenceRepository {
    public static DatabaseReference randomAnyDatabaseReference() {
        String databaseName = RandomStringUtils.randomAlphabetic((int)10);
        return TestDatabaseReferenceRepository.anyDatabaseReference(databaseName);
    }

    public static DatabaseReference anyDatabaseReference(String databaseName) {
        boolean internal = ThreadLocalRandom.current().nextBoolean();
        return internal ? TestDatabaseReferenceRepository.internalDatabaseReference(databaseName) : TestDatabaseReferenceRepository.externalDatabaseReference(databaseName);
    }

    public static DatabaseReference.Internal randomInternalDatabaseReference() {
        String databaseName = RandomStringUtils.randomAlphabetic((int)10);
        return TestDatabaseReferenceRepository.internalDatabaseReference(databaseName);
    }

    public static DatabaseReference.External randomExternalDatabaseReference() {
        String databaseName = RandomStringUtils.randomAlphabetic((int)10);
        return TestDatabaseReferenceRepository.externalDatabaseReference(databaseName);
    }

    public static DatabaseReference.Internal internalDatabaseReference(String databaseName) {
        return TestDatabaseReferenceRepository.internalDatabaseReferenceIn(databaseName, databaseName, "system-root");
    }

    public static DatabaseReference.Internal internalDatabaseReference(String databaseName, String aliasName) {
        return TestDatabaseReferenceRepository.internalDatabaseReferenceIn(databaseName, aliasName, "system-root");
    }

    public static DatabaseReference.Internal internalDatabaseReferenceIn(String databaseName, String namespace) {
        return TestDatabaseReferenceRepository.internalDatabaseReferenceIn(databaseName, databaseName, namespace);
    }

    public static DatabaseReference.Internal internalDatabaseReferenceIn(String databaseName, String aliasName, String namespace) {
        NormalizedDatabaseName normalizedAlias = new NormalizedDatabaseName(aliasName);
        NormalizedDatabaseName normalizedNamespace = new NormalizedDatabaseName(namespace);
        NamedDatabaseId dbId = DatabaseIdFactory.from((String)databaseName, (UUID)UUID.nameUUIDFromBytes(databaseName.getBytes(StandardCharsets.UTF_8)));
        return new DatabaseReference.Internal(normalizedAlias, normalizedNamespace, dbId, Objects.equals(normalizedAlias.name(), dbId.name()));
    }

    public static DatabaseReference.External externalDatabaseReference(String databaseName) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(databaseName, databaseName, "system-root");
    }

    public static DatabaseReference.External externalDatabaseReference(String databaseName, RemoteUri uri) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(databaseName, databaseName, "system-root", uri);
    }

    public static DatabaseReference.External externalDatabaseReference(String databaseName, String aliasName) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(databaseName, aliasName, "system-root");
    }

    public static DatabaseReference.External externalDatabaseReference(String databaseName, String aliasName, RemoteUri uri) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(databaseName, aliasName, "system-root", uri);
    }

    public static DatabaseReference.External externalDatabaseReferenceIn(String localAliasName, String namespace) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(localAliasName, localAliasName, namespace);
    }

    public static DatabaseReference.External externalDatabaseReferenceIn(String localAliasName, String targetDatabaseName, String namespace) {
        List<SocketAddress> addr = List.of(new SocketAddress(localAliasName, 7687));
        RemoteUri uri = new RemoteUri("neo4j", addr, null);
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(localAliasName, targetDatabaseName, namespace, uri);
    }

    public static DatabaseReference.External externalDatabaseReferenceIn(String localAliasName, String targetDatabaseName, String namespace, RemoteUri uri) {
        NormalizedDatabaseName normalizedAlias = new NormalizedDatabaseName(localAliasName);
        NormalizedDatabaseName normalizedTarget = new NormalizedDatabaseName(targetDatabaseName);
        NormalizedDatabaseName normalizedNamespace = new NormalizedDatabaseName(namespace);
        UUID uuid = UUID.randomUUID();
        return new DatabaseReference.External(normalizedTarget, normalizedAlias, normalizedNamespace, uri, uuid);
    }

    public static DatabaseReference.Composite compositeDatabaseReference(String databaseName, Set<DatabaseReference> components) {
        NormalizedDatabaseName name = new NormalizedDatabaseName(databaseName);
        NamedDatabaseId dbId = DatabaseIdFactory.from((String)databaseName, (UUID)UUID.nameUUIDFromBytes(databaseName.getBytes(StandardCharsets.UTF_8)));
        return new DatabaseReference.Composite(name, dbId, components);
    }

    public static class Fixed
    implements DatabaseReferenceRepository {
        private static final DatabaseReference SYSTEM_DATABASE_REFERENCE = new DatabaseReference.Internal(new NormalizedDatabaseName("system"), NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID, true);
        private final Map<NormalizedDatabaseName, DatabaseReference> databaseReferences;

        public Fixed(Collection<DatabaseReference> databaseReferences) {
            this.databaseReferences = databaseReferences.stream().collect(Collectors.toMap(DatabaseReference::alias, Function.identity()));
        }

        public Fixed(DatabaseReference ... databaseReferences) {
            this.databaseReferences = Arrays.stream(databaseReferences).collect(Collectors.toMap(DatabaseReference::alias, Function.identity()));
        }

        public Optional<DatabaseReference> getByAlias(NormalizedDatabaseName databaseAlias) {
            if (Objects.equals("system", databaseAlias.name())) {
                return Optional.of(SYSTEM_DATABASE_REFERENCE);
            }
            return Optional.ofNullable(this.databaseReferences.get(databaseAlias));
        }

        public Set<DatabaseReference> getAllDatabaseReferences() {
            return Set.copyOf(this.databaseReferences.values());
        }

        public Set<DatabaseReference.Internal> getInternalDatabaseReferences() {
            return this.getDatabaseReferences(DatabaseReference.Internal.class);
        }

        public Set<DatabaseReference.External> getExternalDatabaseReferences() {
            return this.getDatabaseReferences(DatabaseReference.External.class);
        }

        public Set<DatabaseReference.Composite> getCompositeDatabaseReferences() {
            return this.getDatabaseReferences(DatabaseReference.Composite.class);
        }

        private <T extends DatabaseReference> Set<T> getDatabaseReferences(Class<T> type) {
            return this.databaseReferences.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toSet());
        }

        public void setDatabaseReference(NormalizedDatabaseName databaseName, DatabaseReference databaseRef) {
            this.databaseReferences.put(databaseName, databaseRef);
        }

        public void removeDatabaseReference(NormalizedDatabaseName databaseName) {
            this.databaseReferences.remove(databaseName);
        }
    }
}

