/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;

public class TestSystemGraphComponent
implements SystemGraphComponent {
    final SystemGraphComponent.Name component;
    final int version;
    SystemGraphComponent.Status status;
    Exception onInit;
    Exception onMigrate;

    public TestSystemGraphComponent(SystemGraphComponent.Name component, SystemGraphComponent.Status status, Exception onInit, Exception onMigrate) {
        this(component, status, onInit, onMigrate, 0);
    }

    public TestSystemGraphComponent(SystemGraphComponent.Name component, SystemGraphComponent.Status status, Exception onInit, Exception onMigrate, int version) {
        this.component = component;
        this.status = status;
        this.onInit = onInit;
        this.onMigrate = onMigrate;
        this.version = version;
    }

    public SystemGraphComponent.Name componentName() {
        return this.component;
    }

    public int getLatestSupportedVersion() {
        return this.version;
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        return this.status;
    }

    public void initializeSystemGraph(GraphDatabaseService system, boolean firstInitialization) throws Exception {
        if (this.status == SystemGraphComponent.Status.UNINITIALIZED) {
            if (this.onInit == null) {
                this.status = SystemGraphComponent.Status.CURRENT;
            } else {
                throw this.onInit;
            }
        }
    }

    public void upgradeToCurrent(GraphDatabaseService system) throws Exception {
        if (this.status == SystemGraphComponent.Status.REQUIRES_UPGRADE) {
            if (this.onMigrate == null) {
                this.status = SystemGraphComponent.Status.CURRENT;
            } else {
                throw this.onMigrate;
            }
        }
    }
}

