/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest.workload;

import java.util.function.BooleanSupplier;
import org.neo4j.kernel.impl.api.CompleteTransaction;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.TransactionRepresentationFactory;
import org.neo4j.storageengine.api.StorageEngineTransaction;

class Worker
implements Runnable {
    private final TransactionAppender transactionAppender;
    private final TransactionRepresentationFactory factory;
    private final BooleanSupplier condition;

    Worker(TransactionAppender transactionAppender, TransactionRepresentationFactory factory, BooleanSupplier condition) {
        this.transactionAppender = transactionAppender;
        this.factory = factory;
        this.condition = condition;
    }

    @Override
    public void run() {
        long latestAppendIndex = 1L;
        while (this.condition.getAsBoolean()) {
            CompleteTransaction transaction = this.factory.nextTransaction(latestAppendIndex);
            try {
                latestAppendIndex = this.transactionAppender.append((StorageEngineTransaction)transaction, LogAppendEvent.NULL);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

