/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.arguments;

import java.util.Locale;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.test.arguments.KernelVersionSource;
import org.neo4j.util.Preconditions;

public class KernelVersionArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<KernelVersionSource> {
    private KernelVersionSource kernelVersionSource;

    public void accept(KernelVersionSource kernelVersionSource) {
        this.kernelVersionSource = kernelVersionSource;
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) {
        Version greaterThan;
        TreeSet<KernelVersion> versions = new TreeSet<KernelVersion>(KernelVersion.VERSIONS);
        Version lessThan = this.getLessThan();
        if (lessThan.compareTo(greaterThan = this.getGreaterThan()) > 0) {
            versions.removeIf(k -> KernelVersionArgumentsProvider.fromKernelVersion(k).compareTo(lessThan) >= 0 || KernelVersionArgumentsProvider.fromKernelVersion(k).compareTo(greaterThan) <= 0);
        } else {
            versions.removeIf(k -> KernelVersionArgumentsProvider.fromKernelVersion(k).compareTo(lessThan) >= 0 && KernelVersionArgumentsProvider.fromKernelVersion(k).compareTo(greaterThan) <= 0);
        }
        return versions.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private Version getLessThan() {
        String lessThan = this.kernelVersionSource.lessThan();
        if (lessThan.isEmpty()) {
            return new Version(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return KernelVersionArgumentsProvider.fromString(lessThan);
    }

    private Version getGreaterThan() {
        String greaterThan = this.kernelVersionSource.greaterThan();
        String atLeast = this.kernelVersionSource.atLeast();
        if (greaterThan.isEmpty() && atLeast.isEmpty()) {
            return new Version(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        Preconditions.checkArgument((greaterThan.isEmpty() != atLeast.isEmpty() ? 1 : 0) != 0, (String)"You cannot specify 'greaterThan' and 'atLeast' at the same time.");
        if (!greaterThan.isEmpty()) {
            return KernelVersionArgumentsProvider.fromString(greaterThan);
        }
        Version v = KernelVersionArgumentsProvider.fromString(atLeast);
        if (v.minor == null) {
            return new Version(v.major - 1, null);
        }
        return new Version(v.major, v.minor - 1);
    }

    static Version fromString(String versionString) {
        if (versionString.toLowerCase(Locale.ROOT).startsWith("v")) {
            versionString = versionString.substring(1);
        }
        if (versionString.equals(KernelVersion.GLORIOUS_FUTURE.name())) {
            return new Version(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        String[] components = versionString.split("[._]");
        Preconditions.checkArgument((components.length > 0 ? 1 : 0) != 0, (String)"We need at least a major version to compare with");
        int major = Integer.parseInt(components[0]);
        if (components.length < 2) {
            return new Version(major, null);
        }
        int minor = Integer.parseInt(components[1]);
        return new Version(major, minor);
    }

    static Version fromKernelVersion(KernelVersion kernelVersion) {
        return KernelVersionArgumentsProvider.fromString(kernelVersion.name());
    }

    record Version(int major, Integer minor) implements Comparable<Version>
    {
        @Override
        public int compareTo(Version other) {
            if (this.minor != null && other.minor != null && this.major == other.major) {
                return Integer.compare(this.minor, other.minor);
            }
            return Integer.compare(this.major, other.major);
        }
    }
}

