/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class TransactionIdChecker {
    private final Path workingDirectory;

    public TransactionIdChecker(Path workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public long parseAllTxLogs() throws IOException {
        long txId = 1L;
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
             ReadableLogChannel channel = this.openLogFile((FileSystemAbstraction)fs, 0);){
            LogEntryReader reader = TestLogEntryReader.logEntryReader();
            LogEntry logEntry = reader.readLogEntry((ReadableLogPositionAwareChannel)channel);
            while (logEntry != null) {
                if (logEntry instanceof LogEntryCommit) {
                    txId = ((LogEntryCommit)logEntry).getTxId();
                }
                logEntry = reader.readLogEntry((ReadableLogPositionAwareChannel)channel);
            }
        }
        return txId;
    }

    private ReadableLogChannel openLogFile(FileSystemAbstraction fs, int version) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((Path)this.workingDirectory, (FileSystemAbstraction)fs).withCommandReaderFactory((CommandReaderFactory)TestCommandReaderFactory.INSTANCE).build();
        LogFile logFile = logFiles.getLogFile();
        PhysicalLogVersionedStoreChannel channel = logFile.openForVersion((long)version);
        return new ReadAheadLogChannel((LogVersionedStoreChannel)channel, (LogVersionBridge)new ReaderLogVersionBridge(logFile), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }
}

