/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class StubStorageCursors
implements StorageReader {
    private static final long NO_ID = -1L;
    private final AtomicLong nextPropertyId = new AtomicLong();
    private final AtomicLong nextTokenId = new AtomicLong();
    private final TokenHolder propertyKeyTokenHolder = new DelegatingTokenHolder((name, internal) -> Math.toIntExact(this.nextTokenId.getAndIncrement()), "PropertyKey");
    private final Map<Long, NodeData> nodeData = new HashMap<Long, NodeData>();
    private final Map<Long, PropertyData> propertyData = new HashMap<Long, PropertyData>();
    private final Map<Long, RelationshipData> relationshipData = new HashMap<Long, RelationshipData>();
    private final Map<SchemaDescriptor, IndexDescriptor> indexDescriptorMap = new HashMap<SchemaDescriptor, IndexDescriptor>();

    private static IndexDescriptor indexDescriptor(EntityType entityType, long id) {
        IndexPrototype indexPrototype = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)entityType)).withIndexType(IndexType.LOOKUP).withIndexProvider(new IndexProviderDescriptor("token-lookup", "1.0"));
        indexPrototype = indexPrototype.withName(SchemaNameUtil.generateName((SchemaDescriptorSupplier)indexPrototype, (String[])new String[0], (String[])new String[0]));
        return indexPrototype.materialise(id);
    }

    public StubStorageCursors withTokenIndexes() {
        this.indexDescriptorMap.put((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR, StubStorageCursors.indexDescriptor(EntityType.NODE, 1L));
        this.indexDescriptorMap.put((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR, StubStorageCursors.indexDescriptor(EntityType.RELATIONSHIP, 2L));
        return this;
    }

    public StubStorageCursors withoutTokenIndexes() {
        this.indexDescriptorMap.clear();
        return this;
    }

    public NodeData withNode(long id) {
        NodeData node = new NodeData(id);
        this.nodeData.put(id, node);
        return node;
    }

    public RelationshipData withRelationship(long id, long startNode, int type, long endNode) {
        RelationshipData data = new RelationshipData(id, startNode, type, endNode);
        this.relationshipData.put(id, data);
        return data;
    }

    private long propertyIdOf(Map<String, Value> properties) {
        if (properties.isEmpty()) {
            return -1L;
        }
        long propertyId = this.nextPropertyId.incrementAndGet();
        this.propertyData.put(propertyId, new PropertyData(properties));
        for (String key : properties.keySet()) {
            this.silentGetOrCreatePropertyKey(key);
        }
        return propertyId;
    }

    private int silentGetOrCreatePropertyKey(String key) {
        try {
            return this.propertyKeyTokenHolder.getOrCreateId(key);
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }

    public TokenHolder propertyKeyTokenHolder() {
        return this.propertyKeyTokenHolder;
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IndexDescriptor indexGetForName(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean indexExists(IndexDescriptor index) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<IndexDescriptor> valueIndexesGetRelated(int[] labels, int propertyKeyId, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<IndexDescriptor> valueIndexesGetRelated(int[] labels, int[] propertyKeyIds, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(int[] tokens, int propertyKeyId, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(int[] tokens, int[] propertyKeyIds, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(int[] changedLabels, int[] unchangedLabels, int[] propertyKeyIds, boolean propertyKeyListIsComplete, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean hasRelatedSchema(int[] labels, int propertyKey, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean hasRelatedSchema(int label, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IntSet[] constraintsGetPropertyTokensForLogicalKey(int token, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<IndexDescriptor> indexGetForSchema(SchemaDescriptor descriptor) {
        if (this.indexDescriptorMap.containsKey(descriptor)) {
            return List.of(this.indexDescriptorMap.get(descriptor)).iterator();
        }
        return Collections.emptyIterator();
    }

    public IndexDescriptor indexGetForSchemaAndType(SchemaDescriptor descriptor, IndexType type) {
        IndexDescriptor index;
        if (this.indexDescriptorMap.containsKey(descriptor) && (index = this.indexDescriptorMap.get(descriptor)).getIndexType() == type) {
            return index;
        }
        return null;
    }

    public long countsForNode(int labelId, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void visitAllCounts(CountsVisitor visitor, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long estimateCountsForNode(int labelId, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long estimateCountsForRelationship(int startLabelId, int typeId, int endLabelId, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long nodesGetCount(CursorContext cursorContext) {
        return this.nodeData.size();
    }

    public long relationshipsGetCount(CursorContext cursorContext) {
        return this.relationshipData.size();
    }

    public int labelCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int propertyKeyCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int relationshipTypeCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean nodeExists(long id, StoreCursors storeCursors) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean relationshipExists(long id, StoreCursors storeCursors) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <T> T getOrCreateSchemaDependantState(Class<T> type, Function<StorageReader, T> factory) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AllNodeScan allNodeScan() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public AllRelationshipsScan allRelationshipScan() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public StorageNodeCursor allocateNodeCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return new StubStorageNodeCursor();
    }

    public StoragePropertyCursor allocatePropertyCursor(CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        return new StubStoragePropertyCursor();
    }

    public StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return new StubStorageRelationshipTraversalCursor();
    }

    public StorageRelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return new StubStorageRelationshipScanCursor();
    }

    public StorageSchemaReader schemaSnapshot() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public TokenNameLookup tokenNameLookup() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public class NodeData
    extends EntityData<NodeData> {
        private final long id;
        private int[] labels;
        private long firstRelationship;

        NodeData(long id) {
            this.labels = ArrayUtils.EMPTY_INT_ARRAY;
            this.firstRelationship = -1L;
            this.id = id;
        }

        public NodeData labels(int ... labels) {
            this.labels = labels;
            return this;
        }

        public NodeData relationship(long firstRelationship) {
            this.firstRelationship = firstRelationship;
            return this;
        }

        public long getId() {
            return this.id;
        }
    }

    public class RelationshipData
    extends EntityData<RelationshipData> {
        private final long id;
        private final long startNode;
        private final int type;
        private final long endNode;

        RelationshipData(long id, long startNode, int type, long endNode) {
            this.id = id;
            this.startNode = startNode;
            this.type = type;
            this.endNode = endNode;
        }

        RelationshipDirection direction(long nodeReference) {
            if (nodeReference == this.startNode) {
                return nodeReference == this.endNode ? RelationshipDirection.LOOP : RelationshipDirection.OUTGOING;
            }
            if (nodeReference == this.endNode) {
                return RelationshipDirection.INCOMING;
            }
            throw new IllegalArgumentException(String.format("Relationship (%d)--[%d]->(%d): is not connected to node:%d", this.startNode, this.type, this.endNode, nodeReference));
        }
    }

    private static class PropertyData {
        private final Map<String, Value> properties;

        PropertyData(Map<String, Value> properties) {
            this.properties = properties;
        }
    }

    private class StubStorageNodeCursor
    implements StorageNodeCursor {
        private long next;
        private NodeData current;
        private Iterator<Long> iterator;

        private StubStorageNodeCursor() {
        }

        public void scan() {
            this.iterator = StubStorageCursors.this.nodeData.keySet().iterator();
            this.current = null;
        }

        public void single(long reference) {
            this.iterator = null;
            this.next = reference;
        }

        public boolean scanBatch(AllNodeScan scan, long sizeHint) {
            throw new UnsupportedOperationException();
        }

        public long entityReference() {
            return this.current.id;
        }

        public int[] labels() {
            return this.current.labels;
        }

        public boolean hasLabel(int label) {
            return ArrayUtils.contains((int[])this.current.labels, (int)label);
        }

        public boolean hasLabel() {
            return this.current.labels.length > 0;
        }

        public boolean hasProperties() {
            return this.current.propertyId != -1L;
        }

        public boolean supportsFastRelationshipsTo() {
            return false;
        }

        public void relationshipsTo(StorageRelationshipTraversalCursor traversalCursor, RelationshipSelection selection, long neighbourNodeReference) {
            traversalCursor.init(this.current.id, -1L, selection);
        }

        public void relationships(StorageRelationshipTraversalCursor traversalCursor, RelationshipSelection selection) {
            traversalCursor.init(this.current.id, -1L, selection);
        }

        public int[] relationshipTypes() {
            return StubStorageCursors.this.relationshipData.values().stream().filter(rel -> rel.startNode == this.current.id || rel.endNode == this.current.id).mapToInt(rel -> rel.type).distinct().sorted().toArray();
        }

        public void degrees(RelationshipSelection selection, Degrees.Mutator mutator) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public long relationshipsReference() {
            return this.current.firstRelationship;
        }

        public Reference propertiesReference() {
            return LongReference.longReference((long)this.current.propertyId);
        }

        public void properties(StoragePropertyCursor propertyCursor, PropertySelection selection) {
            propertyCursor.initNodeProperties(this.propertiesReference(), selection);
        }

        public boolean next() {
            if (this.iterator != null) {
                while (this.iterator.hasNext()) {
                    this.current = StubStorageCursors.this.nodeData.get(this.iterator.next());
                    if (!this.current.inUse) continue;
                    return true;
                }
                this.current = null;
                return false;
            }
            if (this.next != -1L) {
                this.current = StubStorageCursors.this.nodeData.get(this.next);
                this.next = -1L;
                return this.current != null && this.current.inUse;
            }
            return false;
        }

        public void reset() {
            this.iterator = null;
            this.current = null;
        }

        public boolean supportsFastDegreeLookup() {
            return false;
        }

        public void setForceLoad() {
        }

        public void close() {
            this.reset();
        }
    }

    private class StubStoragePropertyCursor
    implements StoragePropertyCursor {
        private Map.Entry<String, Value> current;
        private Iterator<Map.Entry<String, Value>> iterator;

        private StubStoragePropertyCursor() {
        }

        public void initNodeProperties(Reference reference, PropertySelection selection, long ownerReference) {
            this.init(reference, selection);
        }

        public void initRelationshipProperties(Reference reference, PropertySelection selection, long ownerReference) {
            this.init(reference, selection);
        }

        private void init(Reference reference, PropertySelection selection) {
            long id = ((LongReference)reference).id;
            PropertyData properties = StubStorageCursors.this.propertyData.get(id);
            this.iterator = properties != null ? properties.properties.entrySet().iterator() : Collections.emptyIterator();
            this.iterator = Iterators.filter(p -> selection.test(StubStorageCursors.this.propertyKeyTokenHolder.getIdByName((String)p.getKey())), this.iterator);
        }

        public void close() {
        }

        public int propertyKey() {
            return StubStorageCursors.this.silentGetOrCreatePropertyKey(this.current.getKey());
        }

        public ValueGroup propertyType() {
            return this.current.getValue().valueGroup();
        }

        public Value propertyValue() {
            return this.current.getValue();
        }

        public void reset() {
        }

        public void setForceLoad() {
        }

        public boolean next() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            return false;
        }
    }

    private class StubStorageRelationshipTraversalCursor
    implements StorageRelationshipTraversalCursor {
        private Iterator<RelationshipData> iterator;
        private RelationshipData current;
        private long originNodeReference;

        private StubStorageRelationshipTraversalCursor() {
        }

        public boolean next() {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.current = this.iterator.next();
            return true;
        }

        public void reset() {
            this.iterator = null;
            this.current = null;
        }

        public void setForceLoad() {
        }

        public void close() {
        }

        public boolean hasProperties() {
            return this.current.propertyId != -1L;
        }

        public Reference propertiesReference() {
            return LongReference.longReference((long)this.current.propertyId);
        }

        public void properties(StoragePropertyCursor propertyCursor, PropertySelection selection) {
            propertyCursor.initRelationshipProperties(this.propertiesReference(), selection);
        }

        public long entityReference() {
            return this.current.id;
        }

        public int type() {
            return this.current.type;
        }

        public long sourceNodeReference() {
            return this.current.startNode;
        }

        public long targetNodeReference() {
            return this.current.endNode;
        }

        public long neighbourNodeReference() {
            return this.originNodeReference == this.current.startNode ? this.current.endNode : this.current.startNode;
        }

        public long originNodeReference() {
            return this.originNodeReference;
        }

        public void init(long nodeReference, long reference, RelationshipSelection selection) {
            this.originNodeReference = nodeReference;
            this.iterator = StubStorageCursors.this.relationshipData.values().stream().filter(relationship -> relationship.startNode == nodeReference || relationship.endNode == nodeReference).filter(relationship -> selection.test(relationship.type, relationship.direction(nodeReference))).iterator();
        }
    }

    private class StubStorageRelationshipScanCursor
    implements StorageRelationshipScanCursor {
        private Iterator<Long> iterator;
        private RelationshipData current;
        private long next;

        private StubStorageRelationshipScanCursor() {
        }

        public void scan() {
            this.iterator = StubStorageCursors.this.relationshipData.keySet().iterator();
            this.next = -1L;
        }

        public void single(long reference) {
            this.iterator = null;
            this.next = reference;
        }

        public void single(long reference, long sourceNodeReference, int type, long targetNodeReference) {
            this.single(reference);
        }

        public boolean scanBatch(AllRelationshipsScan scan, long sizeHint) {
            throw new UnsupportedOperationException();
        }

        public long entityReference() {
            return this.current.id;
        }

        public int type() {
            return this.current.type;
        }

        public boolean hasProperties() {
            return this.current.propertyId != -1L;
        }

        public long sourceNodeReference() {
            return this.current.startNode;
        }

        public long targetNodeReference() {
            return this.current.endNode;
        }

        public Reference propertiesReference() {
            return LongReference.longReference((long)this.current.propertyId);
        }

        public void properties(StoragePropertyCursor propertyCursor, PropertySelection selection) {
            propertyCursor.initRelationshipProperties(this.propertiesReference(), selection);
        }

        public boolean next() {
            if (this.iterator != null) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                this.next = this.iterator.next();
            }
            if (this.next != -1L) {
                this.current = StubStorageCursors.this.relationshipData.get(this.next);
                this.next = -1L;
                return true;
            }
            return false;
        }

        public void reset() {
            this.current = null;
            this.next = -1L;
        }

        public void setForceLoad() {
        }

        public void close() {
            this.reset();
        }
    }

    class EntityData<SELF>
    extends Data<SELF> {
        long propertyId = -1L;

        EntityData() {
        }

        public SELF propertyId(long propertyId) {
            this.propertyId = propertyId;
            return (SELF)this;
        }

        public SELF properties(Map<String, Value> properties) {
            return this.propertyId(StubStorageCursors.this.propertyIdOf(properties));
        }

        public SELF properties(Object ... properties) {
            return this.properties(MapUtil.genericMap((Object[])properties));
        }
    }

    public static class Data<SELF> {
        boolean inUse = true;

        public SELF inUse(boolean inUse) {
            this.inUse = inUse;
            return (SELF)this;
        }
    }
}

