/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.api.KernelTransaction;

public class Tags {
    private Tags() {
    }

    public static class Suppliers {
        private Suppliers() {
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static abstract class Supplier<TAG>
        implements java.util.function.Supplier<TAG> {
            private final String name;
            private final String separator;
            private final java.util.function.Supplier<String> suffix;
            private final Factories.Factory<TAG> factory;

            protected Supplier(String name, String separator, java.util.function.Supplier<String> suffix, Factories.Factory<TAG> factory) {
                this.name = name;
                this.separator = separator;
                this.suffix = suffix;
                this.factory = factory;
            }

            protected Supplier(String name, java.util.function.Supplier<String> suffix, Factories.Factory<TAG> factory) {
                this(name, "_", suffix, factory);
            }

            public final String name() {
                return this.name;
            }

            @Override
            public final TAG get() {
                return this.factory.fromName(this.name + this.separator + this.suffix.get());
            }

            public final List<TAG> get(int numberOfTags) {
                return Stream.generate(this).limit(numberOfTags).toList();
            }

            public final int getId(KernelTransaction tx) throws KernelException {
                return this.factory.getId(tx, this.get());
            }

            public final List<Integer> getIds(KernelTransaction tx, int numberOfTags) throws KernelException {
                return this.factory.getIds(tx, (Iterable<TAG>)this.get(numberOfTags));
            }
        }

        public static final class PropertyKey
        extends Supplier<String> {
            public PropertyKey(String name, String separator, java.util.function.Supplier<String> suffix) {
                super(name, separator, suffix, Factories.PROPERTY_KEY);
            }

            public PropertyKey(String name, java.util.function.Supplier<String> suffix) {
                super(name, suffix, Factories.PROPERTY_KEY);
            }

            public PropertyKey(java.util.function.Supplier<String> suffix) {
                this("PropertyKey", suffix);
            }
        }

        public static final class RelationshipType
        extends Supplier<org.neo4j.graphdb.RelationshipType> {
            public RelationshipType(String name, String separator, java.util.function.Supplier<String> suffix) {
                super(name, separator, suffix, Factories.RELATIONSHIP_TYPE);
            }

            public RelationshipType(String name, java.util.function.Supplier<String> suffix) {
                super(name, suffix, Factories.RELATIONSHIP_TYPE);
            }

            public RelationshipType(java.util.function.Supplier<String> suffix) {
                this("RelationshipType", suffix);
            }
        }

        public static final class Label
        extends Supplier<org.neo4j.graphdb.Label> {
            public Label(String name, String separator, java.util.function.Supplier<String> suffix) {
                super(name, separator, suffix, Factories.LABEL);
            }

            public Label(String name, java.util.function.Supplier<String> suffix) {
                super(name, suffix, Factories.LABEL);
            }

            public Label(java.util.function.Supplier<String> suffix) {
                this("Label", suffix);
            }
        }

        public static class Suffixes {
            public static java.util.function.Supplier<String> incrementing() {
                return Suffixes.incrementing(0L);
            }

            public static java.util.function.Supplier<String> incrementing(long from) {
                AtomicLong count = new AtomicLong(from);
                return () -> String.valueOf(count.getAndIncrement());
            }

            public static java.util.function.Supplier<String> UUID() {
                return () -> java.util.UUID.randomUUID().toString();
            }

            public static java.util.function.Supplier<String> random(Random random, int numBytes) {
                return () -> {
                    byte[] bytes = new byte[numBytes];
                    random.nextBytes(bytes);
                    StringBuilder sb = new StringBuilder();
                    for (byte b : bytes) {
                        sb.append(String.format("%02x", b));
                    }
                    return sb.toString();
                };
            }

            private Suffixes() {
            }
        }

        public static class UUID {
            public static final Label LABEL = new Label(Suffixes.UUID());
            public static final RelationshipType RELATIONSHIP_TYPE = new RelationshipType(Suffixes.UUID());
            public static final PropertyKey PROPERTY_KEY = new PropertyKey(Suffixes.UUID());

            private UUID() {
            }
        }

        public static class Incrementing {
            public static final Label LABEL = new Label(Suffixes.incrementing());
            public static final RelationshipType RELATIONSHIP_TYPE = new RelationshipType(Suffixes.incrementing());
            public static final PropertyKey PROPERTY_KEY = new PropertyKey(Suffixes.incrementing());

            private Incrementing() {
            }
        }
    }

    public static class Factories {
        public static final Label LABEL = new Label();
        public static final RelationshipType RELATIONSHIP_TYPE = new RelationshipType();
        public static final PropertyKey PROPERTY_KEY = new PropertyKey();

        private Factories() {
        }

        public static final class Label
        extends Factory<org.neo4j.graphdb.Label> {
            @Override
            public org.neo4j.graphdb.Label fromName(String name) {
                return org.neo4j.graphdb.Label.label((String)name);
            }

            @Override
            public int getId(KernelTransaction tx, org.neo4j.graphdb.Label label) throws KernelException {
                return tx.tokenWrite().labelGetOrCreateForName(label.name());
            }

            private Label() {
            }
        }

        public static final class RelationshipType
        extends Factory<org.neo4j.graphdb.RelationshipType> {
            @Override
            public org.neo4j.graphdb.RelationshipType fromName(String name) {
                return org.neo4j.graphdb.RelationshipType.withName((String)name);
            }

            @Override
            public int getId(KernelTransaction tx, org.neo4j.graphdb.RelationshipType relType) throws KernelException {
                return tx.tokenWrite().relationshipTypeGetOrCreateForName(relType.name());
            }

            private RelationshipType() {
            }
        }

        public static final class PropertyKey
        extends Factory<String> {
            @Override
            public String fromName(String name) {
                return name;
            }

            @Override
            public int getId(KernelTransaction tx, String propertyKey) throws KernelException {
                return tx.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
            }

            private PropertyKey() {
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static abstract class Factory<TAG> {
            public abstract TAG fromName(String var1);

            public abstract int getId(KernelTransaction var1, TAG var2) throws KernelException;

            @SafeVarargs
            public final List<Integer> getIds(KernelTransaction tx, TAG ... tags) throws KernelException {
                return this.getIds(tx, (Iterable<TAG>)List.of(tags));
            }

            public final List<Integer> getIds(KernelTransaction tx, Iterable<TAG> tags) throws KernelException {
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (TAG tag : tags) {
                    ids.add(this.getId(tx, tag));
                }
                return ids;
            }
        }
    }
}

