/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.neo4j.io.fs.ChannelNativeAccessor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogTracers;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadUtils;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.test.LatestVersions;

public final class LogTestUtils {
    private LogTestUtils() {
    }

    public static Path[] filterNeostoreLogicalLog(LogFiles logFiles, FileSystemAbstraction fileSystem, LogHook<LogEntry> filter, CommandReaderFactory commandReaderFactory) throws IOException {
        Path[] files;
        for (Path file : files = logFiles.logFiles()) {
            LogTestUtils.filterTransactionLogFile(fileSystem, file, filter, commandReaderFactory);
        }
        return files;
    }

    private static void filterTransactionLogFile(FileSystemAbstraction fileSystem, Path file, LogHook<LogEntry> filter, CommandReaderFactory commandReaderFactory) throws IOException {
        filter.file(file);
        try (StoreChannel in = fileSystem.read(file);){
            LogHeader logHeader = LogHeaderReader.readLogHeader((ReadableByteChannel)in, (boolean)true, (Path)file, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            assert (logHeader != null) : "Looks like we tried to read a log header of an empty pre-allocated file.";
            PhysicalLogVersionedStoreChannel inChannel = new PhysicalLogVersionedStoreChannel(in, logHeader, file, ChannelNativeAccessor.EMPTY_ACCESSOR, (LogTracers)DatabaseTracer.NULL);
            try (ReadableLogChannel inBuffer = ReadAheadUtils.newChannel((LogVersionedStoreChannel)inChannel, (LogHeader)logHeader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                LogEntry entry;
                VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(commandReaderFactory, LatestVersions.BINARY_VERSIONS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                while ((entry = entryReader.readLogEntry((ReadableLogPositionAwareChannel)inBuffer)) != null) {
                    filter.test(entry);
                }
            }
        }
    }

    public static interface LogHook<RECORD>
    extends Predicate<RECORD> {
        public void file(Path var1);

        public void done(Path var1);
    }

    public static class CountingLogHook<RECORD>
    extends LogHookAdapter<RECORD> {
        private int count;

        @Override
        public boolean test(RECORD item) {
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static abstract class LogHookAdapter<RECORD>
    implements LogHook<RECORD> {
        @Override
        public void file(Path file) {
        }

        @Override
        public void done(Path file) {
        }
    }
}

