/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.mvcc.index;

import java.util.Arrays;
import org.neo4j.io.pagecache.context.OldestTransactionIdFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.io.pagecache.context.TransactionIdSnapshotFactory;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.context.VersionContextSupplier;

public class MultiVersionTreeTestContext
implements VersionContext {
    private long committingTxId;
    private long appendIndex;
    private final long lastClosedTxId;
    private final long highestClosed;
    private final long[] notVisible;
    private final long oldestTransactionId;

    MultiVersionTreeTestContext(long closedTxId, long highestClosed, long[] notVisible, long oldestTransactionId) {
        this.lastClosedTxId = closedTxId;
        this.highestClosed = highestClosed;
        this.notVisible = notVisible;
        this.oldestTransactionId = oldestTransactionId;
    }

    public void initRead() {
    }

    public void initWrite(long committingTxId) {
        this.committingTxId = committingTxId;
    }

    public long committingTransactionId() {
        return this.committingTxId;
    }

    public void initAppendIndex(long committingAppendIndex) {
        this.appendIndex = committingAppendIndex;
    }

    public long committingAppendIndex() {
        return this.appendIndex;
    }

    public long lastClosedTransactionId() {
        return this.lastClosedTxId;
    }

    public long highestClosed() {
        return this.highestClosed;
    }

    public void markAsDirty() {
    }

    public boolean isDirty() {
        return false;
    }

    public long[] notVisibleTransactionIds() {
        return this.notVisible;
    }

    public long oldestVisibleTransactionNumber() {
        return this.oldestTransactionId;
    }

    public void refreshVisibilityBoundaries() {
    }

    public void observedChainHead(long headVersion) {
    }

    public boolean invisibleHeadObserved() {
        return false;
    }

    public void resetObsoleteHeadState() {
    }

    public void markHeadInvisible() {
    }

    public long chainHeadVersion() {
        return Long.MIN_VALUE;
    }

    public boolean initializedForWrite() {
        return this.committingTxId > 0L;
    }

    public int stamp() {
        return 0;
    }

    public boolean validateStamp(int stamp) {
        return true;
    }

    public String toString() {
        return "MultiversionTreeTestContext{committingTxId=" + this.committingTxId + ", lastClosedTxId=" + this.lastClosedTxId + ", highestClosed=" + this.highestClosed + ", notVisible=" + Arrays.toString(this.notVisible) + ", oldestTransactionId=" + this.oldestTransactionId + "}";
    }

    public static class MultiVersionTreeTestContextSupplier
    implements VersionContextSupplier {
        private TransactionIdSnapshotFactory snapshotFactory;
        private OldestTransactionIdFactory oldestTransactionIdFactory;

        public void init(TransactionIdSnapshotFactory snapshotFactory, OldestTransactionIdFactory oldestTransactionIdFactory) {
            this.snapshotFactory = snapshotFactory;
            this.oldestTransactionIdFactory = oldestTransactionIdFactory;
        }

        public VersionContext createVersionContext() {
            TransactionIdSnapshot snapshot = this.snapshotFactory.createSnapshot();
            return new MultiVersionTreeTestContext(snapshot.lastClosedTxId(), snapshot.highestEverSeen(), snapshot.notVisibleTransactions(), this.oldestTransactionIdFactory.oldestTransactionId());
        }
    }
}

