/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.jupiter.api.Assertions;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.RangeLayout;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexEntryTestUtil {
    public static <KEY extends NativeIndexKey<KEY>> String generateStringResultingInIndexEntrySize(int size) {
        RangeLayout layout = new RangeLayout(1);
        return IndexEntryTestUtil.generateStringValueResultingInIndexEntrySize(layout, size).stringValue();
    }

    public static <KEY extends NativeIndexKey<KEY>> TextValue generateStringValueResultingInIndexEntrySize(Layout<KEY, ?> layout, int size) {
        StringValue value;
        NativeIndexKey key = (NativeIndexKey)layout.newKey();
        key.initialize(0L);
        int stringLength = size;
        do {
            value = Values.stringValue((String)"A".repeat(stringLength--));
            key.initFromValue(0, (Value)value, NativeIndexKey.Inclusion.NEUTRAL);
        } while (layout.keySize((Object)key) > size);
        Assertions.assertEquals((int)size, (int)layout.keySize((Object)key));
        return value;
    }
}

