/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.values.storable.RandomValues;

public class RandomValuesUtils {
    private RandomValuesUtils() {
    }

    public static RandomValues.Configuration selectStorageEngineDependentConfiguration(GraphDatabaseService dbms) {
        return RandomValuesUtils.selectStorageEngineDependentConfigurationBuilder(dbms).build();
    }

    public static RandomValues.Configuration selectStorageEngineDependentConfiguration(String storageEngineName) {
        return RandomValuesUtils.selectStorageEngineDependentConfigurationBuilder(storageEngineName).build();
    }

    public static RandomValues.ConfigurationBuilder selectStorageEngineDependentConfigurationBuilder(GraphDatabaseService dbms) {
        StorageEngineFactory storageEngine = (StorageEngineFactory)((GraphDatabaseAPI)dbms).getDependencyResolver().resolveOptionalDependency(StorageEngineFactory.class).orElseThrow();
        return RandomValuesUtils.selectStorageEngineDependentConfigurationBuilder(storageEngine.name());
    }

    public static RandomValues.ConfigurationBuilder selectStorageEngineDependentConfigurationBuilder(String storageEngineName) {
        return switch (storageEngineName) {
            case "block" -> RandomValues.newConfigurationBuilder();
            default -> RandomValues.newConfigurationBuilder().includeVectorTypes(false);
        };
    }
}

