/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class TestPropertyScanConsumer
implements PropertyScanConsumer {
    public final List<List<Record>> batches = Collections.synchronizedList(new ArrayList());

    public PropertyScanConsumer.Batch newBatch() {
        return new PropertyScanConsumer.Batch(){
            final List<Record> batchEntityUpdates = new ArrayList<Record>();

            public long addRecord(long entityId, int[] tokens, Map<Integer, Value> properties, MemoryTracker memoryTracker) {
                this.batchEntityUpdates.add(new Record(entityId, tokens, properties));
                long heapSize = properties.values().stream().mapToLong(Measurable::estimatedHeapUsage).sum();
                memoryTracker.allocateHeap(heapSize);
                return heapSize;
            }

            public void process() {
                TestPropertyScanConsumer.this.batches.add(this.batchEntityUpdates);
            }
        };
    }

    public record Record(long entityId, int[] tokens, Map<Integer, Value> properties) {
        @Override
        public String toString() {
            return "Record{entityId=" + this.entityId + ", tokens=" + Arrays.toString(this.tokens) + ", properties=" + String.valueOf(this.properties) + "}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            return this.entityId == record.entityId && Arrays.equals(this.tokens, record.tokens) && Objects.equals(this.properties, record.properties);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.entityId, this.properties);
            result = 31 * result + Arrays.hashCode(this.tokens);
            return result;
        }
    }
}

