/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.vector;

import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.ByteLists;
import org.eclipse.collections.api.factory.primitive.DoubleLists;
import org.eclipse.collections.api.factory.primitive.FloatLists;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.SettingsAccessor;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.Neo4jVectorSimilarityFunction;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.test.LatestVersions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.VectorValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public class VectorTestUtils {
    public static final RichIterable<AnyValue> EUCLIDEAN_VALID_VECTORS;
    public static final RichIterable<AnyValue> EUCLIDEAN_INVALID_VECTORS;
    public static final RichIterable<AnyValue> SIMPLE_COSINE_VALID_VECTORS;
    public static final RichIterable<AnyValue> SIMPLE_COSINE_INVALID_VECTORS;
    public static final RichIterable<AnyValue> L2_NORM_COSINE_VALID_VECTORS;
    public static final RichIterable<AnyValue> L2_NORM_COSINE_INVALID_VECTORS;

    public static RichIterable<AnyValue> validVectorsFor(Neo4jVectorSimilarityFunction function) {
        return switch (function) {
            default -> throw new MatchException(null, null);
            case Neo4jVectorSimilarityFunction.EUCLIDEAN -> EUCLIDEAN_VALID_VECTORS;
            case Neo4jVectorSimilarityFunction.SIMPLE_COSINE -> SIMPLE_COSINE_VALID_VECTORS;
            case Neo4jVectorSimilarityFunction.L2_NORM_COSINE -> L2_NORM_COSINE_VALID_VECTORS;
        };
    }

    public static RichIterable<AnyValue> invalidVectorsFor(Neo4jVectorSimilarityFunction function) {
        return switch (function) {
            default -> throw new MatchException(null, null);
            case Neo4jVectorSimilarityFunction.EUCLIDEAN -> EUCLIDEAN_INVALID_VECTORS;
            case Neo4jVectorSimilarityFunction.SIMPLE_COSINE -> SIMPLE_COSINE_INVALID_VECTORS;
            case Neo4jVectorSimilarityFunction.L2_NORM_COSINE -> L2_NORM_COSINE_INVALID_VECTORS;
        };
    }

    private static ArrayValue toArrayValue(Object array) {
        ArrayValue arrayValue;
        Value value = Values.of((Object)array);
        return value instanceof ArrayValue ? (arrayValue = (ArrayValue)value) : null;
    }

    private static LazyIterable<Value> toArrayAndVectorValues(Object array) {
        return Lists.immutable.of((Object)VectorTestUtils.toArrayValue(array), (Object)VectorTestUtils.toVectorValue(array)).asLazy();
    }

    private static VectorValue toVectorValue(Object vector) {
        Object object = vector;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object2, n)) {
            case 0 -> {
                byte[] array = (byte[])object2;
                yield Values.int8Vector((byte[])array);
            }
            case 1 -> {
                short[] array = (short[])object2;
                yield Values.int16Vector((short[])array);
            }
            case 2 -> {
                int[] array = (int[])object2;
                yield Values.int32Vector((int[])array);
            }
            case 3 -> {
                long[] array = (long[])object2;
                yield Values.int64Vector((long[])array);
            }
            case 4 -> {
                float[] array = (float[])object2;
                VectorValue.ensureValidDimensions((int)array.length);
                yield Values.uncheckedFloat32Vector((float[])array);
            }
            case 5 -> {
                double[] array = (double[])object2;
                VectorValue.ensureValidDimensions((int)array.length);
                yield Values.uncheckedFloat64Vector((double[])array);
            }
            default -> null;
        };
    }

    private static LazyIterable<ListValue> convertEvenElementsToStringValues(Value v) {
        if (v instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)v;
            AnyValue[] array = new AnyValue[arrayValue.intSize()];
            for (int i = 0; i < array.length; ++i) {
                Value value = (Value)arrayValue.value(i);
                array[i] = (i & 1) == 0 ? Values.stringValue((String)value.prettyPrint()) : value;
            }
            return Lists.immutable.of((Object)VirtualValues.list((AnyValue[])array)).asLazy();
        }
        return Lists.immutable.empty().asLazy();
    }

    private static RichIterable<AnyValue> addListValueVersions(RichIterable<? extends AnyValue> values) {
        ListValueConverter converter = new ListValueConverter();
        return Lists.mutable.withAll(values).withAll((Iterable)values.asLazy().selectInstancesOf(ArrayValue.class).collect(converter::toListValue));
    }

    private static double extremeSameFloatValue(double value) {
        int floatSignificandWidth = 24;
        int doubleSignificandWidth = 53;
        int mask = 0xFFFFFFF;
        return Double.longBitsToDouble(Double.doubleToRawLongBits(value) | 0xFFFFFFFL);
    }

    private static byte[] toPrimitive(byte ... array) {
        return array;
    }

    private static short[] toPrimitive(short ... array) {
        return array;
    }

    private static int[] toPrimitive(int ... array) {
        return array;
    }

    private static long[] toPrimitive(long ... array) {
        return array;
    }

    private static float[] toPrimitive(float ... array) {
        return array;
    }

    private static double[] toPrimitive(double ... array) {
        return array;
    }

    private static double[] promote(float ... array) {
        if (array == null) {
            return null;
        }
        double[] promoted = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            promoted[i] = array[i];
        }
        return promoted;
    }

    private static LazyIterable<long[]> signPermutations(long ... values) {
        if (values == null) {
            return null;
        }
        int n = 1 << values.length;
        MutableList perms = Lists.mutable.withInitialCapacity(n);
        for (int p = 0; p < n; ++p) {
            long[] perm = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                long value = values[i];
                boolean flip = (p & 1 << i) != 0;
                perm[i] = flip ? -value : value;
            }
            perms.add((Object)perm);
        }
        return perms.asLazy();
    }

    private static LazyIterable<float[]> signPermutations(float ... values) {
        if (values == null) {
            return null;
        }
        int n = 1 << values.length;
        MutableList perms = Lists.mutable.withInitialCapacity(n);
        for (int p = 0; p < n; ++p) {
            float[] perm = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                float value = values[i];
                boolean flip = (p & 1 << i) != 0;
                perm[i] = flip ? -value : value;
            }
            perms.add((Object)perm);
        }
        return perms.asLazy();
    }

    private static LazyIterable<double[]> signPermutations(double ... values) {
        if (values == null) {
            return null;
        }
        int n = 1 << values.length;
        MutableList perms = Lists.mutable.withInitialCapacity(n);
        for (int p = 0; p < n; ++p) {
            double[] perm = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                double value = values[i];
                boolean flip = (p & 1 << i) != 0;
                perm[i] = flip ? -value : value;
            }
            perms.add((Object)perm);
        }
        return perms.asLazy();
    }

    private static LazyIterable<ListValue> signPermutations(NumberValue ... values) {
        if (values == null) {
            return null;
        }
        int n = 1 << values.length;
        MutableList perms = Lists.mutable.withInitialCapacity(n);
        LongValue zero = Values.longValue((long)0L);
        for (int p = 0; p < n; ++p) {
            NumberValue[] perm = new NumberValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                NumberValue value = values[i];
                boolean flip = (p & 1 << i) != 0;
                perm[i] = flip ? zero.minus(value) : value;
            }
            perms.add((Object)VirtualValues.list((AnyValue[])perm));
        }
        return perms.asLazy();
    }

    public static VectorIndexVersion max(VectorIndexVersion ... versions) {
        return (VectorIndexVersion)Sets.mutable.of((Object[])versions).max();
    }

    public static SetIterable<VectorIndexVersion> inclusiveVersionRangeFrom(VectorIndexVersion from) {
        return VectorTestUtils.inclusiveVersionRange(from, VectorIndexVersion.latestSupportedVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION));
    }

    public static SetIterable<VectorIndexVersion> inclusiveVersionRange(VectorIndexVersion from, VectorIndexVersion to) {
        return LazyIterate.select((Iterable)VectorIndexVersion.KNOWN_VERSIONS, (Predicate & Serializable)version -> from.compareTo((Enum)version) <= 0 && version.compareTo((Enum)to) <= 0).toSet();
    }

    static {
        double smallerDoubleThanSmallestFloatButSameValue = VectorTestUtils.extremeSameFloatValue(-3.4028234663852886E38);
        double smallerDoubleThanSmallestFloat = Math.nextDown(smallerDoubleThanSmallestFloatButSameValue);
        double largerDoubleThanLargestFloatButSameValue = VectorTestUtils.extremeSameFloatValue(3.4028234663852886E38);
        double largerDoubleThanLargestFloat = Math.nextUp(largerDoubleThanLargestFloatButSameValue);
        float squareRootSmallestPositiveFloat = (float)Math.sqrt(Math.nextUp(0.0f));
        float squareRootLargestFloat = (float)Math.sqrt(3.4028234663852886E38);
        float squareRootHalfLargestFloat = (float)Math.sqrt(1.7014117331926443E38);
        double squareRootSmallestPositiveDouble = Math.sqrt(Math.nextUp(0.0));
        double squareRootLargestDouble = Math.sqrt(Double.MAX_VALUE);
        double squareRootHalfLargestDouble = Math.sqrt(8.988465674311579E307);
        double largerThanSquareRootLargestDouble = Math.nextUp(Math.sqrt(Double.MAX_VALUE));
        LazyIterable floatFiniteNonZeroRegularArrays = Lists.mutable.withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(42))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(-1234))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(-559038801))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(-1234567890987654321L))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive((float)Math.E))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(Math.PI))).asLazy();
        LazyIterable floatFiniteNonZeroExtremeIntegralArrays = Lists.mutable.withAll((Iterable)ByteLists.immutable.of(new byte[]{-127, -128, 127}).asLazy().collect((ByteToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0)).flatCollect(VectorTestUtils::toArrayAndVectorValues)).withAll((Iterable)ShortLists.immutable.of(new short[]{-32767, Short.MIN_VALUE, Short.MAX_VALUE}).asLazy().collect((ShortToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0)).flatCollect(VectorTestUtils::toArrayAndVectorValues)).withAll((Iterable)IntLists.immutable.of(new int[]{-2147483647, Integer.MIN_VALUE, Integer.MAX_VALUE}).asLazy().collect((IntToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0)).flatCollect(VectorTestUtils::toArrayAndVectorValues)).withAll((Iterable)LongLists.immutable.of(new long[]{-9223372036854775807L, Long.MIN_VALUE, Long.MAX_VALUE}).asLazy().collect((LongToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0)).flatCollect(VectorTestUtils::toArrayAndVectorValues)).asLazy();
        LazyFloatIterable floatFiniteNonZeroPositiveExtremePrimitiveFloats = FloatLists.immutable.of(new float[]{Float.MIN_VALUE, Float.MIN_NORMAL, Float.MAX_VALUE}).asLazy();
        LazyIterable floatFiniteNonZeroExtremePrimitiveFloatArrays = floatFiniteNonZeroPositiveExtremePrimitiveFloats.flatCollect((FloatToObjectFunction & Serializable)xva$0 -> VectorTestUtils.signPermutations(xva$0));
        LazyIterable floatFiniteNonZeroExtremeFloatArrays = Lists.mutable.withAll((Iterable)floatFiniteNonZeroExtremePrimitiveFloatArrays.flatCollect(VectorTestUtils::toArrayAndVectorValues)).asLazy();
        LazyIterable floatFiniteNonZeroExtremeDoubleArrays = Lists.mutable.of((Object[])new Double[]{smallerDoubleThanSmallestFloatButSameValue, largerDoubleThanLargestFloatButSameValue, Double.MIN_VALUE, Double.MIN_NORMAL}).flatCollect((Function & Serializable)xva$0 -> VectorTestUtils.signPermutations(xva$0)).withAll((Iterable)floatFiniteNonZeroExtremePrimitiveFloatArrays.collect(VectorTestUtils::promote)).asLazy().flatCollect(VectorTestUtils::toArrayAndVectorValues);
        LazyDoubleIterable doubleFiniteNonZeroPositiveExtremePrimitiveDoubles = DoubleLists.immutable.of(new double[]{Double.MIN_VALUE, Double.MIN_NORMAL, Double.MAX_VALUE}).asLazy();
        LazyIterable doubleFiniteNonZeroExtremeDoubleArrays = doubleFiniteNonZeroPositiveExtremePrimitiveDoubles.flatCollect((DoubleToObjectFunction & Serializable)xva$0 -> VectorTestUtils.signPermutations(xva$0)).flatCollect(VectorTestUtils::toArrayAndVectorValues);
        LazyIterable floatFiniteZeroPrimitiveIntegralArrays = Lists.mutable.withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(0))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(0))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(0))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(0L))).asLazy();
        LazyIterable<float[]> floatFiniteZeroPrimitiveFloatArrays = VectorTestUtils.signPermutations(0.0f);
        LazyIterable floatFiniteZeroFloatingPointArrays = Lists.mutable.withAll((Iterable)floatFiniteZeroPrimitiveFloatArrays.flatCollect(VectorTestUtils::toArrayAndVectorValues)).withAll((Iterable)floatFiniteZeroPrimitiveFloatArrays.collect(VectorTestUtils::promote).flatCollect(VectorTestUtils::toArrayAndVectorValues)).asLazy();
        LazyFloatIterable floatFiniteNonZeroSqrtExtremePrimitiveFloats = floatFiniteNonZeroPositiveExtremePrimitiveFloats.collectDouble(Math::sqrt).collectFloat((DoubleToFloatFunction & Serializable)v -> (float)v);
        LazyDoubleIterable doubleFiniteNonZeroSqrtExtremePrimitiveDoubles = doubleFiniteNonZeroPositiveExtremePrimitiveDoubles.collectDouble(Math::sqrt);
        LazyIterable floatFiniteSquareL2NormIntegralArrays = VectorTestUtils.signPermutations(Long.MAX_VALUE, Long.MAX_VALUE).flatCollect(VectorTestUtils::toArrayAndVectorValues);
        LazyIterable floatFiniteSquareL2NormPrimitiveFloatArrays = Lists.mutable.of((Object[])new float[][]{VectorTestUtils.toPrimitive(0.0f, squareRootLargestFloat), VectorTestUtils.toPrimitive(squareRootLargestFloat, 0.0f), VectorTestUtils.toPrimitive(squareRootSmallestPositiveFloat, squareRootSmallestPositiveFloat), VectorTestUtils.toPrimitive(squareRootHalfLargestFloat, squareRootHalfLargestFloat)}).withAll((Iterable)floatFiniteNonZeroSqrtExtremePrimitiveFloats.collect((FloatToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0))).asLazy().flatCollect(VectorTestUtils::signPermutations);
        LazyIterable floatFiniteSquareL2NormFloatingPointArrays = Lists.mutable.withAll((Iterable)floatFiniteSquareL2NormPrimitiveFloatArrays.flatCollect(VectorTestUtils::toArrayAndVectorValues)).withAll((Iterable)floatFiniteSquareL2NormPrimitiveFloatArrays.collect(VectorTestUtils::promote).flatCollect(VectorTestUtils::toArrayAndVectorValues)).asLazy();
        LazyIterable doubleFiniteSquareL2NormDoubleArrays = Lists.mutable.of((Object[])new double[][]{VectorTestUtils.toPrimitive(0.0, squareRootLargestDouble), VectorTestUtils.toPrimitive(squareRootLargestDouble, 0.0), VectorTestUtils.toPrimitive(squareRootSmallestPositiveDouble, squareRootSmallestPositiveDouble), VectorTestUtils.toPrimitive(squareRootHalfLargestDouble, squareRootHalfLargestDouble)}).withAll((Iterable)doubleFiniteNonZeroSqrtExtremePrimitiveDoubles.collect((DoubleToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0))).asLazy().flatCollect(VectorTestUtils::signPermutations).flatCollect(VectorTestUtils::toArrayAndVectorValues);
        LazyIterable<ListValue> floatFiniteSquareL2NormMixedArrays = VectorTestUtils.signPermutations(new NumberValue[]{Values.longValue((long)Long.MAX_VALUE), Values.floatValue((float)9.223372E18f), Values.doubleValue((double)9.223372036854776E18)});
        LazyIterable nonFloatEmptyIntegralArrays = Lists.mutable.of((Object[])new ArrayValue[]{Values.EMPTY_BYTE_ARRAY, Values.EMPTY_SHORT_ARRAY, Values.EMPTY_INT_ARRAY, Values.EMPTY_LONG_ARRAY}).asLazy();
        LazyIterable nonFloatFinitePrimitiveFloatArrays = Lists.mutable.of((Object[])new Float[]{Float.valueOf(Float.NaN), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY)}).flatCollect((Function & Serializable)xva$0 -> VectorTestUtils.signPermutations(xva$0)).asLazy();
        LazyIterable nonDoubleFiniteNonZeroPositiveExtremePrimitiveDoubles = Lists.mutable.of((Object[])new Double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}).asLazy();
        MutableList nonFloatFiniteFloatingPointArrays = Lists.mutable.withAll((Iterable)nonFloatFinitePrimitiveFloatArrays.flatCollect(VectorTestUtils::toArrayAndVectorValues)).withAll((Iterable)Lists.mutable.of((Object[])new Double[]{smallerDoubleThanSmallestFloat, largerDoubleThanLargestFloat, Double.MAX_VALUE}).withAll((Iterable)nonDoubleFiniteNonZeroPositiveExtremePrimitiveDoubles).flatCollect((Function & Serializable)xva$0 -> VectorTestUtils.signPermutations(xva$0)).withAll((Iterable)nonFloatFinitePrimitiveFloatArrays.collect(VectorTestUtils::promote)).flatCollect(VectorTestUtils::toArrayAndVectorValues));
        LazyIterable nonDoubleFiniteDoubleArrays = Lists.mutable.withAll((Iterable)nonDoubleFiniteNonZeroPositiveExtremePrimitiveDoubles).flatCollect((Function & Serializable)xva$0 -> VectorTestUtils.signPermutations(xva$0)).asLazy().flatCollect(VectorTestUtils::toArrayAndVectorValues);
        MutableList nonFloatFiniteSquareL2NormIntegralArrays = Lists.mutable.withAll((Iterable)VectorTestUtils.signPermutations(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE).flatCollect(VectorTestUtils::toArrayAndVectorValues));
        LazyIterable nonFloatFiniteSquareL2NormPrimitiveFloatArrays = Lists.mutable.of((Object[])new float[][]{VectorTestUtils.toPrimitive(0.0f, 0.0f), VectorTestUtils.toPrimitive(squareRootHalfLargestFloat, Math.nextUp(squareRootHalfLargestFloat)), VectorTestUtils.toPrimitive(Float.MAX_VALUE, Float.MAX_VALUE)}).asLazy().flatCollect(VectorTestUtils::signPermutations);
        LazyIterable nonFloatFiniteSquareL2NormFloatingPointArrays = Lists.mutable.withAll((Iterable)nonFloatFiniteSquareL2NormPrimitiveFloatArrays.asLazy().flatCollect(VectorTestUtils::toArrayAndVectorValues)).withAll((Iterable)Lists.mutable.withAll(VectorTestUtils.signPermutations(largerThanSquareRootLargestDouble, largerThanSquareRootLargestDouble)).withAll((Iterable)nonFloatFiniteSquareL2NormPrimitiveFloatArrays.collect(VectorTestUtils::promote)).flatCollect(VectorTestUtils::toArrayAndVectorValues)).asLazy();
        LazyIterable<ListValue> nonFloatFiniteSquareL2NormMixedArrays = VectorTestUtils.signPermutations(new NumberValue[]{Values.longValue((long)Long.MAX_VALUE), Values.floatValue((float)9.223372E18f), Values.doubleValue((double)9.223372036854776E18), Values.longValue((long)Long.MAX_VALUE)});
        LazyIterable nonDoubleFiniteZeroSquareL2NormIntegralArrays = Lists.mutable.withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(0, 0))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(0, 0))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(0, 0))).withAll(VectorTestUtils.toArrayAndVectorValues(VectorTestUtils.toPrimitive(0L, 0L))).asLazy();
        LazyIterable nonDoubleFiniteSquareL2NormDoubleArrays = Lists.mutable.of((Object[])new double[][]{VectorTestUtils.toPrimitive(0.0, 0.0), VectorTestUtils.toPrimitive(squareRootHalfLargestDouble, Math.nextUp(squareRootHalfLargestDouble)), VectorTestUtils.toPrimitive(largerThanSquareRootLargestDouble, largerThanSquareRootLargestDouble), VectorTestUtils.toPrimitive(Double.MAX_VALUE, Double.MAX_VALUE)}).asLazy().flatCollect(VectorTestUtils::signPermutations).flatCollect(VectorTestUtils::toArrayAndVectorValues);
        LazyIterable nonNumericArrays = Lists.mutable.withAll(VectorTestUtils.toArrayAndVectorValues(ArrayUtils.toArray((Object[])new String[]{"clearly", "not", "numeric"}))).withAll((Iterable)Lists.mutable.withAll((Iterable)floatFiniteNonZeroRegularArrays).withAll((Iterable)floatFiniteNonZeroExtremeIntegralArrays).flatCollect(VectorTestUtils::convertEvenElementsToStringValues)).asLazy();
        Comparator objectComparator = Comparator.nullsLast((lhs, rhs) -> {
            if (Objects.equals(lhs, rhs)) {
                return 0;
            }
            return Comparator.comparing(o -> o.getClass().descriptorString()).compare(lhs, rhs);
        });
        Comparator<AnyValue> valueComparator = Comparator.nullsLast(Comparator.comparing(AnyValue::valueRepresentation).thenComparing((lhs, rhs) -> {
            block7: {
                if (!(lhs instanceof SequenceValue)) break block7;
                SequenceValue lhsSequence = (SequenceValue)lhs;
                if (!(rhs instanceof SequenceValue)) break block7;
                SequenceValue rhsSequence = (SequenceValue)rhs;
                int comparison = Integer.compare(lhsSequence.intSize(), rhsSequence.intSize());
                if (comparison != 0) {
                    return comparison;
                }
                for (int i = 0; i < lhsSequence.intSize(); ++i) {
                    Value lhsValue;
                    AnyValue rhsElement;
                    block9: {
                        AnyValue lhsElement;
                        block8: {
                            lhsElement = lhsSequence.value((long)i);
                            rhsElement = rhsSequence.value((long)i);
                            if (!(lhsElement instanceof Value)) break block8;
                            lhsValue = (Value)lhsElement;
                            if (rhsElement instanceof Value) break block9;
                        }
                        return objectComparator.compare(lhsElement, rhsElement);
                    }
                    Value rhsValue = (Value)rhsElement;
                    comparison = Values.COMPARATOR.compare(lhsValue, rhsValue);
                    if (comparison == 0) continue;
                    return comparison;
                }
                return 0;
            }
            if (lhs instanceof VectorValue) {
                VectorValue lhsVector = (VectorValue)lhs;
                if (rhs instanceof VectorValue) {
                    VectorValue rhsVector = (VectorValue)rhs;
                    return Values.COMPARATOR.compare((Value)lhsVector, (Value)rhsVector);
                }
            }
            return objectComparator.compare(lhs, rhs);
        }));
        SIMPLE_COSINE_VALID_VECTORS = VectorTestUtils.addListValueVersions((RichIterable<? extends AnyValue>)Lists.mutable.withAll((Iterable)floatFiniteNonZeroRegularArrays).withAll((Iterable)floatFiniteNonZeroExtremeIntegralArrays).withAll(floatFiniteSquareL2NormMixedArrays).withAll((Iterable)floatFiniteSquareL2NormIntegralArrays).withAll((Iterable)floatFiniteSquareL2NormFloatingPointArrays).toSortedSet(valueComparator)).toImmutableSortedSet(valueComparator);
        L2_NORM_COSINE_VALID_VECTORS = VectorTestUtils.addListValueVersions((RichIterable<? extends AnyValue>)Lists.mutable.withAll(SIMPLE_COSINE_VALID_VECTORS).withAll((Iterable)doubleFiniteSquareL2NormDoubleArrays).toSortedSet(valueComparator)).toImmutableSortedSet(valueComparator);
        EUCLIDEAN_VALID_VECTORS = VectorTestUtils.addListValueVersions((RichIterable<? extends AnyValue>)Lists.mutable.withAll(SIMPLE_COSINE_VALID_VECTORS).withAll((Iterable)floatFiniteZeroPrimitiveIntegralArrays).withAll((Iterable)floatFiniteZeroFloatingPointArrays).withAll((Iterable)floatFiniteNonZeroExtremeFloatArrays).withAll((Iterable)floatFiniteNonZeroExtremeDoubleArrays).toSortedSet(valueComparator)).toImmutableSortedSet(valueComparator);
        EUCLIDEAN_INVALID_VECTORS = VectorTestUtils.addListValueVersions((RichIterable<? extends AnyValue>)Lists.mutable.with((Object[])new AnyValue[]{Values.NO_VALUE}).with(null).withAll((Iterable)nonFloatEmptyIntegralArrays).withAll((Iterable)nonFloatFiniteFloatingPointArrays).withAll((Iterable)nonNumericArrays).toSortedSet(valueComparator)).toSortedSet(valueComparator).asUnmodifiable();
        L2_NORM_COSINE_INVALID_VECTORS = VectorTestUtils.addListValueVersions((RichIterable<? extends AnyValue>)Lists.mutable.with((Object[])new AnyValue[]{Values.NO_VALUE}).with(null).withAll((Iterable)doubleFiniteNonZeroExtremeDoubleArrays).withAll((Iterable)nonDoubleFiniteZeroSquareL2NormIntegralArrays).withAll((Iterable)nonDoubleFiniteSquareL2NormDoubleArrays).withAll((Iterable)nonDoubleFiniteDoubleArrays).withAll((Iterable)nonNumericArrays).toSortedSet(valueComparator)).toSortedSet(valueComparator).asUnmodifiable();
        SIMPLE_COSINE_INVALID_VECTORS = VectorTestUtils.addListValueVersions((RichIterable<? extends AnyValue>)Lists.mutable.withAll(EUCLIDEAN_INVALID_VECTORS).withAll(L2_NORM_COSINE_INVALID_VECTORS).withAll((Iterable)floatFiniteNonZeroExtremeFloatArrays).withAll((Iterable)nonFloatFiniteSquareL2NormIntegralArrays).withAll((Iterable)nonFloatFiniteSquareL2NormFloatingPointArrays).withAll(nonFloatFiniteSquareL2NormMixedArrays).toSortedSet(valueComparator)).toSortedSet(valueComparator).asUnmodifiable();
    }

    private static class ListValueConverter {
        private int counter = -1;

        private ListValueConverter() {
        }

        ListValue toListValue(ArrayValue arrayValue) {
            ++this.counter;
            this.counter %= ListValueType.VALUES.length;
            return ListValueType.VALUES[this.counter].toListValue(arrayValue);
        }

        private static enum ListValueType {
            PRIMITIVE_ARRAY{

                @Override
                ListValue toListValue(ArrayValue arrayValue) {
                    AnyValue[] array = new AnyValue[arrayValue.intSize()];
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = arrayValue.value(i);
                    }
                    return VirtualValues.list((AnyValue[])array);
                }
            }
            ,
            LIST{

                @Override
                ListValue toListValue(ArrayValue arrayValue) {
                    ArrayList<AnyValue> list = new ArrayList<AnyValue>(arrayValue.intSize());
                    for (AnyValue element : arrayValue) {
                        list.add(element);
                    }
                    return VirtualValues.fromList(list);
                }
            }
            ,
            ARRAY_VALUE{

                @Override
                ListValue toListValue(ArrayValue arrayValue) {
                    return VirtualValues.fromArray((ArrayValue)arrayValue);
                }
            };

            static final ListValueType[] VALUES;

            abstract ListValue toListValue(ArrayValue var1);

            static {
                VALUES = ListValueType.values();
            }
        }
    }

    public static class VectorIndexSettings {
        private final MutableMap<IndexSetting, Object> settings = Maps.mutable.empty();

        private VectorIndexSettings() {
        }

        public static VectorIndexSettings create() {
            return new VectorIndexSettings();
        }

        public static VectorIndexSettings from(Map<IndexSetting, Object> settings) {
            VectorIndexSettings vectorIndexSettings = VectorIndexSettings.create();
            settings.forEach(vectorIndexSettings::set);
            return vectorIndexSettings;
        }

        public static VectorIndexSettings from(IndexConfig config) {
            return VectorIndexSettings.from(IndexSettingUtil.toIndexSettingObjectMapFromIndexConfig((IndexConfig)config));
        }

        public VectorIndexSettings set(IndexSetting setting, Object value) {
            this.settings.put((Object)setting, value);
            return this;
        }

        public VectorIndexSettings unset(IndexSetting setting) {
            this.settings.remove((Object)setting);
            return this;
        }

        public VectorIndexSettings withDimensions(int dimensions) {
            return this.set(IndexSetting.vector_Dimensions(), dimensions);
        }

        public VectorIndexSettings withSimilarityFunction(VectorSimilarityFunction similarityFunction) {
            return this.withSimilarityFunction(similarityFunction.functionName());
        }

        public VectorIndexSettings withSimilarityFunction(String similarityFunction) {
            return this.set(IndexSetting.vector_Similarity_Function(), similarityFunction);
        }

        public VectorIndexSettings withQuantizationEnabled() {
            return this.withQuantizationEnabled(true);
        }

        public VectorIndexSettings withQuantizationDisabled() {
            return this.withQuantizationEnabled(false);
        }

        public VectorIndexSettings withQuantizationEnabled(boolean quantizationEnabled) {
            return this.set(IndexSetting.vector_Quantization_Enabled(), quantizationEnabled);
        }

        public VectorIndexSettings withHnswM(int M) {
            return this.set(IndexSetting.vector_Hnsw_M(), M);
        }

        public VectorIndexSettings withHnswEfConstruction(int efConstruction) {
            return this.set(IndexSetting.vector_Hnsw_Ef_Construction(), efConstruction);
        }

        public IndexConfig toIndexConfig() {
            return IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(this.settings);
        }

        public IndexConfig toIndexConfigWith(VectorIndexVersion version) {
            return version.indexSettingValidator().validateToVectorIndexConfig(this.toSettingsAccessor()).config();
        }

        public Map<IndexSetting, Object> toMap() {
            return this.settings.asUnmodifiable();
        }

        public Map<IndexSetting, Object> toMapWith(VectorIndexVersion version) {
            return VectorIndexSettings.from(this.toIndexConfigWith(version)).toMap();
        }

        public SortedMap<String, Object> toStringObjectMap() {
            return this.settings.keyValuesView().toSortedMap(String.CASE_INSENSITIVE_ORDER, (Function & Serializable)kv -> ((IndexSetting)kv.getOne()).getSettingName(), Pair::getTwo).asUnmodifiable();
        }

        public SortedMap<String, Object> toStringObjectMapWith(VectorIndexVersion version) {
            return VectorIndexSettings.from(this.toIndexConfigWith(version)).toStringObjectMap();
        }

        public MapValue toMapValue() {
            MapValueBuilder mapBuilder = new MapValueBuilder(this.settings.size());
            this.settings.keyValuesView().forEach((Procedure & Serializable)kv -> mapBuilder.add(((IndexSetting)kv.getOne()).getSettingName(), (AnyValue)Values.of((Object)kv.getTwo())));
            return mapBuilder.build();
        }

        public MapValue toMapValueWith(VectorIndexVersion version) {
            return VectorIndexSettings.from(this.toIndexConfigWith(version)).toMapValue();
        }

        public SettingsAccessor toSettingsAccessor() {
            return new SettingsAccessor.IndexSettingObjectMapAccessor(this.toMap());
        }

        public SettingsAccessor toSettingsAccessorWith(VectorIndexVersion version) {
            return new SettingsAccessor.IndexSettingObjectMapAccessor(this.toMapWith(version));
        }
    }
}

