/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public final class TestDatabaseReferenceRepository {
    public static DatabaseReference randomAnyDatabaseReference() {
        String databaseName = RandomStringUtils.randomAlphabetic((int)10);
        return TestDatabaseReferenceRepository.anyDatabaseReference(databaseName);
    }

    public static DatabaseReference anyDatabaseReference(String databaseName) {
        boolean internal = ThreadLocalRandom.current().nextBoolean();
        return internal ? TestDatabaseReferenceRepository.internalDatabaseReference(databaseName) : TestDatabaseReferenceRepository.externalDatabaseReference(databaseName);
    }

    public static DatabaseReferenceImpl.Internal randomInternalDatabaseReference() {
        String databaseName = RandomStringUtils.randomAlphabetic((int)10);
        return TestDatabaseReferenceRepository.internalDatabaseReference(databaseName);
    }

    public static DatabaseReferenceImpl.External randomExternalDatabaseReference() {
        String databaseName = RandomStringUtils.randomAlphabetic((int)10);
        return TestDatabaseReferenceRepository.externalDatabaseReference(databaseName);
    }

    public static DatabaseReferenceImpl.Internal internalDatabaseReference(String databaseName) {
        return TestDatabaseReferenceRepository.internalDatabaseReferenceIn(databaseName, databaseName, "system-root");
    }

    public static DatabaseReferenceImpl.Internal internalDatabaseReference(String databaseName, String aliasName) {
        return TestDatabaseReferenceRepository.internalDatabaseReferenceIn(databaseName, aliasName, "system-root");
    }

    public static DatabaseReferenceImpl.Internal internalDatabaseReferenceIn(String databaseName, String namespace) {
        return TestDatabaseReferenceRepository.internalDatabaseReferenceIn(databaseName, databaseName, namespace);
    }

    public static DatabaseReferenceImpl.Internal internalDatabaseReferenceIn(String databaseName, String aliasName, String namespace) {
        NormalizedDatabaseName normalizedAlias = new NormalizedDatabaseName(aliasName);
        NormalizedDatabaseName normalizedNamespace = new NormalizedDatabaseName(namespace);
        NamedDatabaseId dbId = DatabaseIdFactory.from((String)databaseName, (UUID)UUID.nameUUIDFromBytes(databaseName.getBytes(StandardCharsets.UTF_8)));
        return new DatabaseReferenceImpl.Internal(normalizedAlias, normalizedNamespace, dbId, Objects.equals(normalizedAlias.name(), dbId.name()));
    }

    public static DatabaseReferenceImpl.External externalDatabaseReference(String databaseName) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(databaseName, databaseName, "system-root");
    }

    public static DatabaseReferenceImpl.External externalDatabaseReference(String databaseName, RemoteUri uri) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(databaseName, databaseName, "system-root", uri);
    }

    public static DatabaseReferenceImpl.External externalDatabaseReference(String databaseName, String aliasName) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(databaseName, aliasName, "system-root");
    }

    public static DatabaseReferenceImpl.External externalDatabaseReference(String databaseName, String aliasName, RemoteUri uri) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(databaseName, aliasName, "system-root", uri);
    }

    public static DatabaseReferenceImpl.External externalDatabaseReferenceIn(String localAliasName, String namespace) {
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(localAliasName, localAliasName, namespace);
    }

    public static DatabaseReferenceImpl.External externalDatabaseReferenceIn(String localAliasName, String targetDatabaseName, String namespace) {
        List<SocketAddress> addr = List.of(new SocketAddress(localAliasName, 7687));
        RemoteUri uri = new RemoteUri("neo4j", addr, null);
        return TestDatabaseReferenceRepository.externalDatabaseReferenceIn(localAliasName, targetDatabaseName, namespace, uri);
    }

    public static DatabaseReferenceImpl.External externalDatabaseReferenceIn(String localAliasName, String targetDatabaseName, String namespace, RemoteUri uri) {
        NormalizedDatabaseName normalizedAlias = new NormalizedDatabaseName(localAliasName);
        NormalizedDatabaseName normalizedTarget = new NormalizedDatabaseName(targetDatabaseName);
        NormalizedDatabaseName normalizedNamespace = new NormalizedDatabaseName(namespace);
        UUID uuid = UUID.randomUUID();
        return new DatabaseReferenceImpl.External(normalizedTarget, normalizedAlias, normalizedNamespace, uri, uuid);
    }

    public static DatabaseReferenceImpl.Composite compositeDatabaseReference(String databaseName, Set<DatabaseReference> components) {
        NormalizedDatabaseName name = new NormalizedDatabaseName(databaseName);
        NamedDatabaseId dbId = DatabaseIdFactory.from((String)databaseName, (UUID)UUID.nameUUIDFromBytes(databaseName.getBytes(StandardCharsets.UTF_8)));
        return new DatabaseReferenceImpl.Composite(name, dbId, components);
    }

    public static class Fixed
    implements DatabaseReferenceRepository {
        private static final DatabaseReference SYSTEM_DATABASE_REFERENCE = new DatabaseReferenceImpl.Internal(new NormalizedDatabaseName("system"), NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID, true);
        private final Map<NormalizedDatabaseName, DatabaseReference> databaseReferences;
        private final Map<NormalizedDatabaseName, DatabaseReference> databaseReferencesByDisplayName;
        private final Map<NormalizedCatalogEntry, DatabaseReference> catalogDatabaseReferences;
        private final Map<UUID, DatabaseReference> databaseReferencesByUUID;

        public Fixed(Collection<DatabaseReference> databaseReferences) {
            this.databaseReferences = databaseReferences.stream().collect(Collectors.toMap(DatabaseReference::alias, Function.identity()));
            this.databaseReferencesByDisplayName = databaseReferences.stream().collect(Collectors.toMap(DatabaseReference::fullName, Function.identity()));
            this.catalogDatabaseReferences = databaseReferences.stream().collect(Collectors.toMap(DatabaseReference::catalogEntry, Function.identity()));
            this.databaseReferencesByUUID = databaseReferences.stream().collect(Collectors.toMap(DatabaseReference::id, Function.identity()));
        }

        public Fixed(DatabaseReference ... databaseReferences) {
            this.databaseReferences = Arrays.stream(databaseReferences).collect(Collectors.toMap(DatabaseReference::alias, Function.identity()));
            this.databaseReferencesByDisplayName = Arrays.stream(databaseReferences).collect(Collectors.toMap(DatabaseReference::fullName, Function.identity()));
            this.catalogDatabaseReferences = Arrays.stream(databaseReferences).collect(Collectors.toMap(DatabaseReference::catalogEntry, Function.identity()));
            this.databaseReferencesByUUID = Arrays.stream(databaseReferences).filter(dbRef -> dbRef.isPrimary() || dbRef.isComposite()).collect(Collectors.toMap(DatabaseReference::id, Function.identity()));
        }

        public Optional<DatabaseReference> getByAlias(NormalizedCatalogEntry entry) {
            return Optional.ofNullable(this.catalogDatabaseReferences.get(entry));
        }

        public Optional<DatabaseReference> getByAlias(NormalizedDatabaseName databaseAlias) {
            if (Objects.equals("system", databaseAlias.name())) {
                return Optional.of(SYSTEM_DATABASE_REFERENCE);
            }
            return Optional.ofNullable(this.databaseReferences.get(databaseAlias));
        }

        public Optional<DatabaseReference> getByDisplayName(NormalizedDatabaseName displayName) {
            return Optional.ofNullable(this.databaseReferencesByDisplayName.get(displayName));
        }

        public Optional<DatabaseReference> getByUuid(UUID databaseId) {
            if (Objects.equals(SYSTEM_DATABASE_REFERENCE.id(), databaseId)) {
                return Optional.of(SYSTEM_DATABASE_REFERENCE);
            }
            return Optional.ofNullable(this.databaseReferencesByUUID.get(databaseId));
        }

        public Set<DatabaseReference> getAllDatabaseReferences() {
            return Set.copyOf(this.databaseReferences.values());
        }

        public Set<DatabaseReferenceImpl.Composite> getCompositeDatabaseReferences() {
            return this.getDatabaseReferences(DatabaseReferenceImpl.Composite.class);
        }

        private <T extends DatabaseReference> Set<T> getDatabaseReferences(Class<T> type) {
            return this.databaseReferences.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toSet());
        }

        public void removeDatabaseReference(NormalizedDatabaseName databaseName) {
            this.databaseReferences.remove(databaseName);
        }
    }
}

